CREATE TABLE IF NOT EXISTS public."Projects"
(
    "Id" bigserial NOT NULL,
    "Name" character varying(1500) NOT NULL,
    "Key" character varying(100) NOT NULL,
    "Color" character varying(10),
    "Type" integer NOT NULL DEFAULT 0,
    "OwnerId" bigint NOT NULL DEFAULT 0,
    "ParentId" bigint,
    "ImageId" bigint,
    "IconId" bigint,
    "TemplateId" integer,
    "CustomerId" integer NOT NULL,
    "Status" integer NOT NULL DEFAULT 0,
    "State" integer DEFAULT 1,
    "Flags" integer NOT NULL DEFAULT 0,
    "StartDate" timestamp without time zone,
    "EndDate" timestamp without time zone,
    "ExternalId" character varying(128),
    "Timestamp" timestamp without time zone NOT NULL DEFAULT timezone('utc'::text, now()),
    "Updated" timestamp without time zone,
    "MaxId" bigint NOT NULL DEFAULT 0,
    "Description" character varying(4000),
    "Order" bigint DEFAULT 0,
    "DeleteUserId" bigint NULL,
    CONSTRAINT "Projects_pkey" PRIMARY KEY ("Key")
);
 

 

CREATE INDEX IF NOT EXISTS "IDX_Projects-ExternalId"
    ON public."Projects" USING btree
    ("ExternalId" COLLATE pg_catalog."default" ASC NULLS LAST)
    TABLESPACE pg_default;

CREATE INDEX IF NOT EXISTS "IDX_Projects-Id-OwnerId"
    ON public."Projects" USING btree
    ("Id" ASC NULLS LAST, "OwnerId" ASC NULLS LAST, "Order" ASC NULLS LAST)
    TABLESPACE pg_default;

CREATE INDEX IF NOT EXISTS "IDX_Projects-ParentId"
		ON public."Projects" USING btree
		("ParentId" ASC NULLS LAST)
		TABLESPACE pg_default;