#!/bin/bash

if [ $# -ne 2 ]; then
    echo "Использование: $0 <исходный email> <новый email>"
    exit 1
fi

DB_HOST=$(grep -oP "host=[^\";]*" /etc/dovecot/dovecot-pgsql.conf | head -1 | cut -d'=' -f2 | cut -d' ' -f1)
DB_USER=$(grep -oP "user=[^\";]*" /etc/dovecot/dovecot-pgsql.conf | head -1 | cut -d'=' -f2 | cut -d' ' -f1)
DB_PASS=$(grep -oP "password=[^\";]*" /etc/dovecot/dovecot-pgsql.conf | head -1 | cut -d'=' -f2 | cut -d' ' -f1)
DB_NAME=$(grep -oP "dbname=[^\";]*" /etc/dovecot/dovecot-pgsql.conf | head -1 | cut -d'=' -f2 | cut -d' ' -f1)
DB_PORT=5432

EMAIL_OLD=$(echo "$1" | tr '[:upper:]' '[:lower:]')
EMAIL_NEW=$(echo "$2" | tr '[:upper:]' '[:lower:]')

result=$(psql -h $DB_HOST -U $DB_USER -d $DB_NAME -p $DB_PORT -t -c "SELECT COUNT(*) FROM virtual_users WHERE email='$EMAIL_NEW'")
if [ "$result" -ne 0 ]; then
    echo "Новый адрес уже занят"
    exit 1
fi

result=$(psql -h $DB_HOST -U $DB_USER -d $DB_NAME -p $DB_PORT -t -c "SELECT COUNT(*) FROM virtual_users WHERE email='$EMAIL_OLD'")
if [ "$result" -eq 0 ]; then
    echo "Почтовый ящик не найден"
    exit 1
fi

if psql -h $DB_HOST -U $DB_USER -d $DB_NAME -p $DB_PORT -c "UPDATE virtual_users SET email='$EMAIL_NEW' WHERE email='$EMAIL_OLD'"; then
    echo "Ящик успешно обновлен"
else
    echo "Ошибка SQL-запроса"
    exit 1
fi

VIRTUAL_MAILBOX_BASE=$(grep -oP "virtual_mailbox_base =[^\";]*" /etc/postfix/main.cf | head -1 | cut -d'=' -f2)
echo $VIRTUAL_MAILBOX_BASE
if [ -z "$VIRTUAL_MAILBOX_BASE" ]; then
    echo "Путь к каталогу писем почтовых ящиков не найден"
    exit 1    
fi

path_mail_old=$(find $VIRTUAL_MAILBOX_BASE -name "$EMAIL_OLD" | tr '[:upper:]' '[:lower:]')
echo $path_mail_old

path_mail_new=$(echo "$path_mail_old" | sed "s/$EMAIL_OLD/$EMAIL_NEW/g")
echo $path_mail_new
mkdir -p "$path_mail_new"

rsync -av "$path_mail_old"/ "$path_mail_new"/