#!/bin/bash

DB_HOST=$(grep -oP "host=[^\";]*" /etc/dovecot/dovecot-pgsql.conf | head -1 | cut -d'=' -f2 | cut -d' ' -f1)
DB_USER=$(grep -oP "user=[^\";]*" /etc/dovecot/dovecot-pgsql.conf | head -1 | cut -d'=' -f2 | cut -d' ' -f1)
DB_PASS=$(grep -oP "password=[^\";]*" /etc/dovecot/dovecot-pgsql.conf | head -1 | cut -d'=' -f2 | cut -d' ' -f1)
DB_NAME=$(grep -oP "dbname=[^\";]*" /etc/dovecot/dovecot-pgsql.conf | head -1 | cut -d'=' -f2 | cut -d' ' -f1)
DB_PORT=5432

ALIAS=$(echo "$1" | tr '[:upper:]' '[:lower:]')
EMAIL=$(echo "$2" | tr '[:upper:]' '[:lower:]')

# Извлекаем домен из email
DOMAIN=$(echo "$EMAIL" | awk -F'@' '{print $2}')

# Получаем ID домена из таблицы virtual_domains
DOMAIN_ID=$(psql -h $DB_HOST -U $DB_USER -d $DB_NAME -p $DB_PORT -t -c "SELECT id FROM virtual_domains WHERE name='$DOMAIN'")

if [ -z "$DOMAIN_ID" ]; then
    echo "Домен не найден"
    exit 1
fi

# Выполнение запроса на добавление алиаса в таблицу virtual_aliases с указанным domain_id
psql -h $DB_HOST -U $DB_USER -d $DB_NAME -p $DB_PORT -c "INSERT INTO virtual_aliases (domain_id, source, destination) VALUES ('$DOMAIN_ID', '$ALIAS', '$EMAIL');"

# Проверка выполнения запроса и вывод соответствующего сообщения
if [ $? -eq 0 ]; then
    echo "Алиас успешно добавлен"
else
    echo "Ошибка добавления алиаса"
fi