#!/bin/bash

DB_HOST=$(grep -oP "host=[^\";]*" /etc/dovecot/dovecot-pgsql.conf | head -1 | cut -d'=' -f2 | cut -d' ' -f1)
DB_USER=$(grep -oP "user=[^\";]*" /etc/dovecot/dovecot-pgsql.conf | head -1 | cut -d'=' -f2 | cut -d' ' -f1)
DB_PASS=$(grep -oP "password=[^\";]*" /etc/dovecot/dovecot-pgsql.conf | head -1 | cut -d'=' -f2 | cut -d' ' -f1)
DB_NAME=$(grep -oP "dbname=[^\";]*" /etc/dovecot/dovecot-pgsql.conf | head -1 | cut -d'=' -f2 | cut -d' ' -f1)
DB_PORT=5432

DEL_USER=$(echo "$1" | tr '[:upper:]' '[:lower:]')

function delete_sender_acl {
    # Удаляем запись из таблицы sender_acl
    local email="$1"
    if psql -h $DB_HOST -U $DB_USER -d $DB_NAME -p $DB_PORT -c "DELETE FROM sender_acl WHERE email='$email'"; then
        echo "Почтовый ящик удален из sender_acl"
    else
        echo "Ошибка при удалении записи из sender_acl"
        return 1
    fi
}

function delete_mailbox {
    # Проверяем наличие в базе
    result=$(psql -h $DB_HOST -U $DB_USER -d $DB_NAME -p $DB_PORT -t -c "SELECT COUNT(*) FROM virtual_users WHERE email='$1'")
    if [ "$result" -eq 0 ]; then
        echo "Почтовый ящик не найден"
        return 1
    fi

    # Удаляем запись из sender_acl
    if ! delete_sender_acl "$1"; then
        echo "Предупреждение: не удалось удалить запись из sender_acl, но продолжаем удаление пользователя"
    fi

    # Удаляем почтовую учетную запись
    if psql -h $DB_HOST -U $DB_USER -d $DB_NAME -p $DB_PORT -c "DELETE FROM virtual_users WHERE email='$1'"; then
        echo "Почтовый ящик удален"
    else
        echo "Ошибка sql-запроса"
        return 1
    fi
}

delete_mailbox "$DEL_USER"
