#!/bin/bash

DB_HOST=$(grep -oP "host=[^\";]*" /etc/dovecot/dovecot-mysql.conf | head -1 | cut -d'=' -f2 | cut -d' ' -f1)
DB_USER=$(grep -oP "user=[^\";]*" /etc/dovecot/dovecot-mysql.conf | head -1 | cut -d'=' -f2 | cut -d' ' -f1)
DB_PASS=$(grep -oP "password=[^\";]*" /etc/dovecot/dovecot-mysql.conf | head -1 | cut -d'=' -f2 | cut -d' ' -f1)
DB_NAME=$(grep -oP "dbname=[^\";]*" /etc/dovecot/dovecot-mysql.conf | head -1 | cut -d'=' -f2 | cut -d' ' -f1)

# Запрос ввода исходного адреса
ALIAS_OLD=$1
ALIAS_NEW=$2

# Проверяем наличие алиаса в базе
result=$(mysql -u$DB_USER -p$DB_PASS $DB_NAME -s -N -e "SELECT COUNT(*) FROM virtual_aliases WHERE source='$ALIAS_OLD'")
if [ "$result" -eq 0 ]; then
    echo "Алиас не найден."
    exit 1
fi

# Переводим новое название алиаса в нижний регистр
ALIAS_NEW=$(echo "$ALIAS_NEW" | tr '[:upper:]' '[:lower:]')

# Обновляем адрес назначения в базе
if mysql -u$DB_USER -p$DB_PASS $DB_NAME -e "UPDATE virtual_aliases SET destination='$ALIAS_NEW' WHERE source='$ALIAS_OLD'"; then
    echo "Алиас успешно обновлен."
else
    echo "Ошибка sql-запроса"
    exit 1
fi

