#/bin/bash

RABBITMQ_INSTALLED=0
PG_SERVER_INSTALLED=0
PG_CLIENT_INSTALLED=0
DS_DEPENDENCIES_INSTALLED=0
DS_INSTALLED=0
DS_EXTERNAL_INSTALLED=0
CDDISK_DEPENDENCIES_INSTALLED=0
CDDISK_INSTALLED=0
CDDISK_ONLY_INSTALLATION=0
CDMAIL_INSTALLED=0
CALENDAR_INSTALLED=0

resultFunc=0

OS_NAME="unknown"
OS_VERSION_HI=""
OS_VERSION_LOW=""

fn_detect_os()
{
    if dpkg --help &> /dev/null; then
	if [ -e /etc/astra_version ]; then
	    OS_NAME="astra"
	    VERSION=$(cat /etc/astra_version)
	    OS_VERSION_HI=${VERSION%%.*}
	    OS_VERSION_LOW=${VERSION#*.}
	    echo "$OS_NAME $OS_VERSION_HI $OS_VERSION_LOW"
	elif [ -e /etc/os-release ]; then
	    echo "os-release found"
	    ID=$(grep -oP '(?<=^ID=).+' /etc/os-release | tr -d '"')
	    VERSION=$(grep -oP '(?<=^VERSION_ID=).+' /etc/os-release | tr -d '"')
	    OS_VERSION_HI=${VERSION%%.*}
	    OS_VERSION_LOW=${VERSION#*.}
	    #echo "$ID VERSION_HI=$OS_VERSION_HI VERSION_LOW=$OS_VERSION_LOW"
	    if [ "$ID" = "debian" ]; then
		OS_NAME=$ID
		echo "$OS_NAME $OS_VERSION_HI.$OS_VERSION_LOW"
	    elif [ "$ID" = "ubuntu" ]; then
		OS_NAME=$ID
		echo "$OS_NAME $OS_VERSION_HI.$OS_VERSION_LOW"
	    else
		echo "Unsupported OS: $ID:$VERSION"
	    fi
	else
	    echo "Unsupported OS"
	fi
    else
	echo "Unsupported OS"
    fi
}

fn_fill_apt_sorces()
{
    #if [ "$OFFLINE_INSTALLER" != "true" ]; then
    if ! [ -f /var/tmp/r7offline ]; then
	if [ "$OS_NAME" = "astra" ]; then
	    sudo apt -y install ca-certificates
	    echo "deb [trusted=yes] https://mirror.yandex.ru/debian/ buster main contrib non-free" | cat > /etc/apt/sources.list.d/debian.list && apt update
	    if [ "$OS_VERSION_HI" = "1" ] && [ "$OS_VERSION_LOW" = "7.4" ]; then
		echo "Astra 1.7.4 make /etc/apt/sources.list.d/10-astra.list"
		echo "deb https://dl.astralinux.ru/astra/stable/1.7_x86-64/repository-main/ 1.7_x86-64 main contrib non-free" | cat > /etc/apt/sources.list.d/10-astra.list
		echo "deb https://dl.astralinux.ru/astra/stable/1.7_x86-64/repository-update/ 1.7_x86-64 main contrib non-free" | cat >> /etc/apt/sources.list.d/10-astra.list
		echo "deb https://dl.astralinux.ru/astra/stable/1.7_x86-64/repository-base/ 1.7_x86-64 main contrib non-free" | cat >> /etc/apt/sources.list.d/10-astra.list
		echo "deb https://dl.astralinux.ru/astra/stable/1.7_x86-64/repository-extended/ 1.7_x86-64 main contrib non-free" | cat >> /etc/apt/sources.list.d/10-astra.list
		echo "deb https://dl.astralinux.ru/astra/stable/1.7_x86-64/repository-extended/ 1.7_x86-64 astra-ce" | cat >> /etc/apt/sources.list.d/10-astra.list
		echo "deb https://dl.astralinux.ru/astra/stable/1.7_x86-64/uu/last/repository-update/ 1.7_x86-64 main contrib non-free" | cat >> /etc/apt/sources.list.d/10-astra.list
		sudo apt update
	    fi
	else
	    sudo apt update
	    sudo apt install software-properties-common -y
	    sudo apt update
	    sudo apt-add-repository contrib
	    if [ "$OS_NAME" = "ubuntu" ] && [ $OS_VERSION_HI = 22 ]; then
		echo "Set up libssl1.1"
		wget "http://security.ubuntu.com/ubuntu/pool/main/o/openssl/libssl1.1_1.1.1f-1ubuntu2_amd64.deb"
		sudo dpkg -i libssl1*
		rm libssl1*
		sudo apt -y install nginx-core nginx-full nginx-extras
	    fi
	    if [ "$OS_NAME" = "debian" ] && [ $OS_VERSION_HI = 11 ]; then
		sudo apt -y install nginx-core nginx-full nginx-extras
	    fi
	fi
    fi
}

fn_install_ms_fonts()
{
    echo "127.0.0.1 downloads.sourceforge.net" >>/etc/hosts
    cp -R ./corefonts /var/www/html/
    cd ./ms
    sudo dpkg -i ttf-mscorefonts-installer_3.8.1_all.deb
    cd ..
    sudo sed -i "s#127.0.0.1 downloads.sourceforge.net##g" /etc/hosts
}

fn_install_tools()
{
    sudo DEBIAN_FRONTEND=noninteractive apt install -y redis-server whiptail xfonts-utils wget nginx cabextract openjdk-17-jdk
}

fn_post_cddisk_install()
{
    if [ "$OS_NAME" = "astra" ]; then
	sudo sed -i '/^/s/^/#/' /etc/apt/sources.list.d/debian.list && sudo apt update
	echo "Astra set access to /var/www/r7-office/documentserver"
	sudo chmod 755 /var/www/r7-office/documentserver
	sudo chmod 755 /opt/r7-office
    fi
    sudo supervisorctl restart cddisk:*
}

fn_make_clean_install()
{
    resultFunc=0
    echo "Making clean install."
    MAKEHTTPS=$(debconf-show cddisk | grep make-https | cut -d ':' -f 2 | tr -d ' ')
    echo "MAKEHTTPS=$MAKEHTTPS"
    if [ "$MAKEHTTPS" = "true" ]; then
	if [ -d /etc/nginx/ssl ]; then
	    DOMAIN=$(debconf-show cddisk | grep site-domain | cut -d ':' -f 2 | tr -d ' ')
	    echo "Remove ssl certificates for $DOMAIN"
	    sudo rm /etc/nginx/ssl/$DOMAIN.key
	    sudo rm /etc/nginx/ssl/$DOMAIN.crt
	fi
    fi
    sudo apt-get -y purge cdmail
    sudo apt-get -y purge cddisk-calendar
    sudo apt-get -y purge cddisk
    if [ -f /var/www/r7-office/documentserver/server/FileConverter/bin/docbuilder ]; then
	echo "Purge documment server."
	sudo DEBIAN_FRONTEND=noninteractive apt-get -y purge r7-office-documentserver*
	if [ -f /etc/r7-office/documentserver/nginx/ds.conf ]; then
	    sudo rm /etc/r7-office/documentserver/nginx/ds.conf
	fi
	if [ -f /etc/r7-office/documentserver/local.json ]; then
	    sudo rm /etc/r7-office/documentserver/local.json
	fi
	sudo rm -r /etc/r7-office
	sudo rm -r /var/www/r7-office
    fi
    sudo DEBIAN_FRONTEND=noninteractive apt-get -y purge postgresql*
}

fn_install_rabbitmq()
{
    resultFunc=0
    echo "Install rabbitmq server."
    sudo DEBIAN_FRONTEND=noninteractive apt-get -o Dpkg::Options::="--force-confdef" -o Dpkg::Options::="--force-confold" -y install rabbitmq-server
    resultFunc="$?"
    if [ $resultFunc = 0 ]; then
	RABBITMQ_INSTALLED=1
	rabbit_pass=$(cat /dev/urandom | tr -dc A-Za-z0-9 | head -c 12)
	rabbitmqctl add_user team $rabbit_pass
	rabbitmqctl set_user_tags team administrator
	rabbitmqctl set_permissions -p / team ".*" ".*" ".*"  
	echo cddisk cddisk/team-rabbit-pass string $rabbit_pass | sudo debconf-set-selections
    fi
}

fn_install_pg_server()
{
    resultFunc=0
    echo "Install postgresql on local pc."
    sudo apt-get -y install postgresql
    resultFunc="$?"
    if [ $resultFunc = 0 ]; then
	PG_SERVER_INSTALLED=1
	path_pg_hba=$(find /etc/postgresql -name pg_hba.conf)
	echo postgresql conf path is: $path_pg_hba
	sudo cat <<EOF >$path_pg_hba
# "local" is for Unix domain socket connections only
local   all             all                        peer
# IPv4 local connections:
host    all        all             127.0.0.1/32     trust
# Allow replication connections from localhost, by a user with the
# replication privilege.
local   replication     all                       peer
host    replication     all        127.0.0.1/32   md5
host    all        all             ::1/128     trust
EOF
	sudo systemctl enable postgresql
	sudo systemctl stop postgresql
	sudo systemctl start postgresql
	sudo echo "" >> /var/tmp/r7mkpg
	sudo echo cddisk cddisk/db-create-postgresql select true | sudo debconf-set-selections
    fi
}

fn_install_pg_client()
{
    resultFunc=0
    echo "Install postgresql client on local pc."
    sudo apt-get -y install postgresql-client
    resultFunc="$?"
    if [ $resultFunc = 0 ]; then
	PG_CLIENT_INSTALLED=1
	sudo echo cddisk cddisk/db-create-postgresql select false | sudo debconf-set-selections
    fi
}

fn_install_ds_local()
{
    resultFunc=0
    echo "Install Document Server."
    if [ -f /var/www/r7-office/documentserver/server/FileConverter/bin/docbuilder ]; then
	echo "Document server allready installed."
    else
	echo "Document server not installed."
	if [ -f /var/tmp/r7mkpg ]; then
	    sudo -i -u postgres psql -c "CREATE DATABASE ds;"
	    sudo -i -u postgres psql -c "CREATE USER ds WITH password 'ds';"
	    sudo -i -u postgres psql -c "GRANT ALL privileges ON DATABASE ds TO ds;"
	    sudo -i -u postgres psql -c "ALTER DATABASE ds OWNER TO ds;"
	    sudo rm /var/tmp/r7mkpg
	fi
	echo "Install Document Server."
	echo r7-office-documentserver ds/jwt-secret password $DocumentServerJWTkey | sudo debconf-set-selections
	echo r7-office-documentserver ds/jwt-enabled boolean true | sudo debconf-set-selections
	echo r7-office-documentserver ds/ds-port select 8083 | sudo debconf-set-selections
	echo r7-office-documentserver ds/jwt-header string AuthorizationJWT | sudo debconf-set-selections
	echo r7-office-documentserver ds/db-pwd password $DocumentServerDBPassword | sudo debconf-set-selections
	echo CDDisk cddisk/jwt-key password $DocumentServerJWTkey | sudo debconf-set-selections
	echo CDDisk cddisk/ds-external boolean false | sudo debconf-set-selections
	sudo DEBIAN_FRONTEND=noninteractive apt-get -y install redis redis-server debconf adduser ca-certificates coreutils curl libasound2 libcairo2 libcurl4 libcurl3-gnutls libgconf-2-4 libgtk-3-0 libstdc++6 libxml2 libxss1 libxtst6 logrotate nginx-extras postgresql-client  pwgen redis-tools supervisor xvfb zlib1g
	resultFunc="$?"
	if [ $resultFunc = 0 ]; then
	    DS_DEPENDENCIES_INSTALLED=1
	    sudo apt-get -y install ./r7-office-documentserver*.deb
	    resultFunc="$?"
	    if [ $resultFunc = 0 ]; then
		DS_INSTALLED=1
	    fi
	fi
    fi
}

fn_install_ds_external()
{
    resultFunc=0
    echo CDDisk cddisk/document-url password $ExternalDocumentServerDomain | sudo debconf-set-selections
    echo CDDisk cddisk/jwt-key password $DocumentServerJWTkey | sudo debconf-set-selections
    echo CDDisk cddisk/ds-external boolean true | sudo debconf-set-selections
    DS_EXTERNAL_INSTALLED=1
}

fn_install_cddisk()
{
    resultFunc=0
    sudo DEBIAN_FRONTEND=noninteractive apt-get -y install apt-transport-https curl
    resultFunc="$?"
    if [ $resultFunc = 0 ]; then
	CDDISK_DEPENDENCIES_INSTALLED=1

	if ! [ -f /var/tmp/r7offline ]; then
	    if [ -e /etc/astra_version ]; then
		wget -O - https://packages.microsoft.com/keys/microsoft.asc | gpg --dearmor | sudo tee /etc/apt/trusted.gpg.d/microsoft.asc.gpg > /dev/null
		sudo wget https://packages.microsoft.com/config/debian/10/prod.list -O /etc/apt/sources.list.d/microsoft-prod.list
		sudo apt-get update

		wget https://packages.microsoft.com/ubuntu/20.04/prod/pool/main/d/dotnet-host/dotnet-host-7.0.3-x64.deb
		sudo apt-get -y install ./dotnet-host*.deb
		sudo rm ./dotnet-host*.deb
	    else
		wget https://packages.microsoft.com/config/ubuntu/20.04/packages-microsoft-prod.deb
		sudo dpkg -i packages-microsoft-prod.deb
		wget -qO- https://packages.microsoft.com/keys/microsoft.asc | sudo apt-key add -
		sudo apt-get update
	    fi
	fi

	if [ -d /var/tmp/sslcert ]; then
	    sudo rm -r /var/tmp/sslcert
	fi
	if [ -f /var/tmp/error ]; then
	    sudo rm /var/tmp/error
	fi
	cp -r ./../sslcert/ /var/tmp/

	echo cddisk cddisk/upgrade boolean false | sudo debconf-set-selections
	echo cddisk cddisk/install-cdmail boolean true | sudo debconf-set-selections
	sudo apt-get -y install dotnet-host-7.0
	sudo apt-get -y install ./CDDisk*.deb
	resultFunc="$?"
	if [ $resultFunc = 0 ]; then
	    CDDISK_INSTALLED=1
	    if [ "$OS_NAME" = "debian" ] || [ "$OS_NAME" = "ubuntu" ] || [ -f /var/tmp/r7offline ]; then
		if [ "$CDDiskMakeHTTPS"="true" ]; then
		    sed -i "s#listen 443 ssl; http2 on;#listen 443 ssl http2;#g" /etc/nginx/sites-available/admin
		    sed -i "s#listen 443 ssl; http2 on;#listen 443 ssl http2;#g" /etc/nginx/sites-available/cddisk
		    sed -i "s#listen 443 ssl; http2 on;#listen 443 ssl http2;#g" /etc/nginx/sites-available/contacts
		    sed -i "s#listen 443 ssl; http2 on;#listen 443 ssl http2;#g" /etc/nginx/sites-available/projects
		    sed -i "s#listen 443 ssl; http2 on;#listen 443 ssl http2;#g" /etc/nginx/sites-available/forms
		    sed -i "s#listen 443 ssl; http2 on;#listen 443 ssl http2;#g" /etc/nginx/sites-available/pages
		    systemctl restart nginx || true
		fi
	    fi
	    DOMAINCDMAIL=$(debconf-show cddisk | grep site-domain | cut -d ':' -f 2 | tr -d ' ')
	    CDDISKPREFIX=$(debconf-show cddisk | grep cddisk-name | cut -d ':' -f 2 | tr -d ' ')
	    PREFIXCDMAIL=$(debconf-show cddisk | grep cdmail-name | cut -d ':' -f 2 | tr -d ' ')
	    PREFIXCALENDAR=$(debconf-show cddisk | grep calendar-name | cut -d ':' -f 2 | tr -d ' ')

	    if [ -f cddisk-calendar*.deb ] && [ -f cdmail*.deb ]; then
		echo cdmail cdmail/is-prompt-domain boolean false | sudo debconf-set-selections
		echo cdmail cdmail/domain string $DOMAINCDMAIL | sudo debconf-set-selections
		echo cdmail cdmail/prefix string $PREFIXCDMAIL | sudo debconf-set-selections
		echo cdmail cdmail/prefix-cddisk string $CDDISKPREFIX | sudo debconf-set-selections
		sudo apt-get -y install ./cdmail*.deb
		resultFunc="$?"
		if [ $resultFunc = 0 ]; then
		    CDMAIL_INSTALLED=1
		    if [ "$OS_NAME" = "debian" ] || [ "$OS_NAME" = "ubuntu" ] || [ -f /var/tmp/r7offline ]; then
			if [ "$CDDiskMakeHTTPS"="true" ]; then
			    sed -i "s#listen 443 ssl; http2 on;#listen 443 ssl http2;#g" /etc/nginx/sites-available/cdmail
			    systemctl restart nginx || true
			fi
		    fi
		    echo calendar calendar/domain string $DOMAINCDMAIL | sudo debconf-set-selections
		    echo calendar calendar/prefix string $PREFIXCALENDAR | sudo debconf-set-selections
		    echo calendar calendar/cddisk-prefix string $CDDISKPREFIX | sudo debconf-set-selections
		    sudo apt-get -y install ./cddisk-calendar*.deb
		    resultFunc="$?"
		    if [ $resultFunc = 0 ]; then
			CALENDAR_INSTALLED=1
			if [ "$OS_NAME" = "debian" ] || [ "$OS_NAME" = "ubuntu" ] || [ -f /var/tmp/r7offline ]; then
			    if [ "$CDDiskMakeHTTPS"="true" ]; then
				sed -i "s#listen 443 ssl; http2 on;#listen 443 ssl http2;#g" /etc/nginx/sites-available/calendar
				systemctl restart nginx || true
			    fi
			fi
		    fi
		fi
	    else
		CDDISK_ONLY_INSTALLATION=1
		echo "cddisk only installation"
	    fi

	    if [ $resultFunc = 0 ]; then
		if [ -f /var/tmp/error ]; then
		    sudo rm -r /var/tmp/sslcert
		    sudo rm /var/tmp/error
		    #whiptail --title "cddisk" --msgbox "Certificates not found in sslcert dir. HTTPS support disabled." 10 60
		fi
		if [ -f /var/tmp/r7mkpg ]; then
		    sudo rm /var/tmp/r7mkpg
		fi
		MAKEHTTPS=$(debconf-show cddisk | grep make-https | cut -d ':' -f 2 | tr -d ' ')
		echo "MAKEHTTPS=$MAKEHTTPS"
		if [ "$MAKEHTTPS" = "true" ] && [ -d /var/tmp/sslcert/ ]; then
		    if [ InstallDocumentServer = "true" ]; then
			mkdir /etc/r7-office/documentserver
			mkdir /etc/r7-office/documentserver/nginx
		    fi
		    mkdir /var/www/r7-office/Data/ssl
		    sudo cp -f ./ds.conf /etc/r7-office/documentserver/nginx/ds.conf
		    DOMAIN=$(debconf-show cddisk | grep site-domain | cut -d ':' -f 2 | tr -d ' ')
		    PREFIX=$(debconf-show cddisk | grep ds-name | cut -d ':' -f 2 | tr -d ' ')
		    if ! [ InstallDocumentServer = "true" ]; then
			SECRET=$(cat /etc/r7-office/documentserver/local.json | grep secretString | sed 's/\"//g' | cut -d ':' -f 2 | tr -d ' ')
		    else
			SECRET=$(debconf-show cddisk | grep jwt-key | cut -d ':' -f 2 | tr -d ' ')
		    fi
		    sudo cp /var/tmp/sslcert/$DOMAIN.crt /var/www/r7-office/Data/ssl/$DOMAIN.crt
		    sudo cp /var/tmp/sslcert/$DOMAIN.key /var/www/r7-office/Data/ssl/$DOMAIN.key
		    if [ "$OS_NAME" = "debian" ] || [ "$OS_NAME" = "ubuntu" ]; then
			sed -i "s#listen 0.0.0.0:443 ssl; http2 on;#listen 0.0.0.0:443 ssl http2;#g" /etc/r7-office/documentserver/nginx/ds.conf
		    fi
		    sudo sed -i "s#server_name ds.devr7.ru;#server_name $PREFIX.$DOMAIN;#g" /etc/r7-office/documentserver/nginx/ds.conf
		    sudo sed -i "s#ssl_certificate /etc/nginx/ssl/devr7.ru.crt;#ssl_certificate /var/www/r7-office/Data/ssl/$DOMAIN.crt;#g" /etc/r7-office/documentserver/nginx/ds.conf
		    sudo sed -i "s#ssl_certificate_key /etc/nginx/ssl/devr7.ru.key;#ssl_certificate_key /var/www/r7-office/Data/ssl/$DOMAIN.key;#g" /etc/r7-office/documentserver/nginx/ds.conf
		    sudo sed -i "s#set \$secure_link_secret Vrd68RbCZG99DaO6xSSd;#set \$secure_link_secret $SECRET;#g" /etc/r7-office/documentserver/nginx/ds.conf
		    service nginx restart
		    if ! [ InstallDocumentServer = "true" ]; then
			sudo bash /usr/bin/documentserver-update-securelink.sh
		    fi
		    sudo rm -r /var/tmp/sslcert
		    if ! [ InstallDocumentServer = "true" ]; then
			sudo bash /usr/bin/documentserver-generate-allfonts.sh
		    fi
		fi
		#if [ -e /etc/astra_version ]; then
		#    echo ""
		#else
		#    rm packages-microsoft-prod.deb*
		#fi
	    fi
	fi
    fi
}

fn_install_astra()
{
    resultFunc=0
    sVER=$(cat /etc/astra_version)
    sVERHI=${sVER%%.*}
    sVERLOW=${sVER#*.}
    if [ "$sVERHI" = "1" ] && [ "$sVERLOW" = "7.4" ]; then
    echo "Astra 1.7.4"
    if [ "true" = "$InstallDocumentServer" ]; then
        sudo adduser --quiet --home "/var/www/r7-office/documentserver" --system --group ds
    fi
    if [ -f /var/tmp/r7mkpg ]; then
        sudo adduser --quiet --home "/opt/r7-office" --system --group cddisk
    fi
    #udo chmod 755 /opt/r7-office
    if [ -f "/usr/sbin/pdpl-user" ]; then
        if [ "true" = "$InstallDocumentServer" ]; then
	/usr/sbin/pdpl-user -z ds
        fi
        if [ -f /var/tmp/r7mkpg ]; then
	/usr/sbin/pdpl-user -z cddisk
        fi
    fi
    if [ -f /var/tmp/r7mkpg ]; then
        if [ -f "/usr/sbin/usermod" ]; then
	/usr/sbin/usermod -a -G shadow postgres
        fi
        if [ -f "/usr/bin/setfacl" ]; then
	if [ -d "/etc/parsec/macdb" ]; then
	    setfacl -d -m u:postgres:r /etc/parsec/macdb
	    setfacl -R -m u:postgres:r /etc/parsec/macdb
	    setfacl -m u:postgres:rx /etc/parsec/macdb
	fi
	if [ -d "/etc/parsec/capdb" ]; then
	    setfacl -d -m u:postgres:r /etc/parsec/capdb
	    setfacl -R -m u:postgres:r /etc/parsec/capdb
	    setfacl -m u:postgres:rx /etc/parsec/capdb
	fi
        fi
    fi
    fi
}

fn_result_print()
{
    echo "RABBITMQ_INSTALLED=$RABBITMQ_INSTALLED"
    echo "PG_SERVER_INSTALLED=$PG_SERVER_INSTALLED"
    echo "PG_CLIENT_INSTALLED=$PG_CLIENT_INSTALLED"
    echo "DS_DEPENDENCIES_INSTALLED=$DS_DEPENDENCIES_INSTALLED"
    echo "DS_INSTALLED=$DS_INSTALLED"
    echo "DS_EXTERNAL_INSTALLED=$DS_EXTERNAL_INSTALLED"
    echo "CDDISK_DEPENDENCIES_INSTALLED=$CDDISK_DEPENDENCIES_INSTALLED"
    echo "CDDISK_INSTALLED=$CDDISK_INSTALLED"
    echo "CDDISK_ONLY_INSTALLATION=$CDDISK_ONLY_INSTALLATION"
    echo "CDMAIL_INSTALLED=$CDMAIL_INSTALLED"
    echo "CALENDAR_INSTALLED=$CALENDAR_INSTALLED"
    if [ -f opt.json ]; then
	rm opt.json
    fi
    echo "{" >> opt.json
    echo "	\"RABBITMQ_INSTALLED\":$RABBITMQ_INSTALLED," >> opt.json
    echo "	\"PG_SERVER_INSTALLED\":$PG_SERVER_INSTALLED," >> opt.json
    echo "	\"PG_CLIENT_INSTALLED\":$PG_CLIENT_INSTALLED," >> opt.json
    echo "	\"DS_DEPENDENCIES_INSTALLED\":$DS_DEPENDENCIES_INSTALLED," >> opt.json
    echo "	\"DS_INSTALLED\":$DS_INSTALLED," >> opt.json
    echo "	\"DS_EXTERNAL_INSTALLED\":$DS_EXTERNAL_INSTALLED," >> opt.json
    echo "	\"CDDISK_DEPENDENCIES_INSTALLED\":$CDDISK_DEPENDENCIES_INSTALLED," >> opt.json
    echo "	\"CDDISK_INSTALLED\":$CDDISK_INSTALLED," >> opt.json
    echo "	\"CDDISK_ONLY_INSTALLATION\":$CDDISK_ONLY_INSTALLATION," >> opt.json
    echo "	\"CDMAIL_INSTALLED\":$CDMAIL_INSTALLED," >> opt.json
    echo "	\"CALENDAR_INSTALLED\":$CALENDAR_INSTALLED," >> opt.json
    echo "	\"MakeCleanInstall\":$MakeCleanInstall" >> opt.json
    echo "	\"InstallPostgresServer\":$InstallPostgresServer," >> opt.json
    echo "	\"InstallDocumentServer\":$InstallDocumentServer," >> opt.json
    echo "	\"DocumentServerJWTkey\":\"$DocumentServerJWTkey\"," >> opt.json
    echo "	\"DocumentServerDBPassword\":\"$DocumentServerDBPassword\"," >> opt.json
    echo "	\"ExternalDocumentServerDomain\":\"$ExternalDocumentServerDomain\"," >> opt.json
    echo "	\"InstallCDDisk\":\"$InstallCDDisk\"," >> opt.json
    echo "	\"CDDiskDatabaseType\":\"$CDDiskDatabaseType\"," >> opt.json
    echo "	\"CDDiskCreateDatabase\":\"$CDDiskCreateDatabase\"," >> opt.json
    echo "	\"CDDiskDatabaseHost\":\"$CDDiskDatabaseHost\"," >> opt.json
    echo "	\"CDDiskDatabasePort\":\"$CDDiskDatabasePort\"," >> opt.json
    echo "	\"CDDiskDatabaseCreateUser\":\"$CDDiskDatabaseCreateUser\"," >> opt.json
    echo "	\"CDDiskDatabaseUser\":\"$CDDiskDatabaseUser\"," >> opt.json
    echo "	\"CDDiskDatabaseName\":\"$CDDiskDatabaseName\"," >> opt.json
    echo "	\"CDDiskDatabasePassword\":\"$CDDiskDatabasePassword\"," >> opt.json
    echo "	\"CDDiskDatabaseCreatePassword\":\"$CDDiskDatabaseCreatePassword\"," >> opt.json
    echo "	\"CDDiskSaltKey\":\"$CDDiskSaltKey\"," >> opt.json
    echo "	\"CDDiskMakeHTTPS\":$CDDiskMakeHTTPS," >> opt.json
    echo "	\"CDDiskDomainName\":\"$CDDiskDomainName\"," >> opt.json
    echo "	\"CDDiskPrefixName\":\"$CDDiskPrefixName\"," >> opt.json
    echo "	\"AdminPrefixName\":\"$AdminPrefixName\"," >> opt.json
    echo "	\"ContactsPrefixName\":\"$ContactsPrefixName\"," >> opt.json
    echo "	\"CDMailPrefixName\":\"$CDMailPrefixName\"," >> opt.json
    echo "	\"CalendarPrefixName\":\"$CalendarPrefixName\"," >> opt.json
    echo "	\"DSPrefixName\":\"$DSPrefixName\"," >> opt.json
    echo "	\"ProjectsPrefixName\":\"$ProjectsPrefixName\"," >> opt.json
    echo "	\"PagesPrefixName\":\"$PagesPrefixName\"," >> opt.json
    echo "	\"FormsPrefixName\":\"$FormsPrefixName\"" >> opt.json
    echo "}" >> opt.json
    cp -f opt.json /opt/r7-office/opt.json
}

fn_main_install()
{
if [ -f "script.json" ]; then
    echo "Install params from script."
    apt-get install -y jq
    input_file="script.json"
    MakeCleanInstall=`jq -r '.MakeCleanInstall' "$input_file"`
    InstallPostgresServer=`jq -r '.InstallPostgresServer' "$input_file"` 
    InstallDocumentServer=`jq -r '.InstallDocumentServer' "$input_file"`
    DocumentServerJWTkey=`jq -r '.DocumentServerJWTkey' "$input_file"`
    DocumentServerDBPassword=`jq -r '.DocumentServerDBPassword' "$input_file"`
    ExternalDocumentServerDomain=`jq -r '.ExternalDocumentServerDomain' "$input_file"`
    InstallCDDisk=`jq -r '.InstallCDDisk' "$input_file"`
    CDDiskDatabaseType=`jq -r '.CDDiskDatabaseType' "$input_file"`
    CDDiskCreateDatabase=`jq -r '.CDDiskCreateDatabase' "$input_file"`
    CDDiskDatabaseHost=`jq -r '.CDDiskDatabaseHost' "$input_file"`
    CDDiskDatabasePort=`jq -r '.CDDiskDatabasePort' "$input_file"`
    CDDiskDatabaseCreateUser=`jq -r '.CDDiskDatabaseCreateUser' "$input_file"`
    CDDiskDatabaseUser=`jq -r '.CDDiskDatabaseUser' "$input_file"`
    CDDiskDatabaseName=`jq -r '.CDDiskDatabaseName' "$input_file"`
    CDDiskDatabasePassword=`jq -r '.CDDiskDatabasePassword' "$input_file"`
    CDDiskDatabaseCreatePassword=`jq -r '.CDDiskDatabaseCreatePassword' "$input_file"`
    CDDiskSaltKey=`jq -r '.CDDiskSaltKey' "$input_file"`
    CDDiskMakeHTTPS=`jq -r '.CDDiskMakeHTTPS' "$input_file"`
    CDDiskDomainName=`jq -r '.CDDiskDomainName' "$input_file"`
    CDDiskPrefixName=`jq -r '.CDDiskPrefixName' "$input_file"`
    AdminPrefixName=`jq -r '.AdminPrefixName' "$input_file"`
    ContactsPrefixName=`jq -r '.ContactsPrefixName' "$input_file"`
    CDMailPrefixName=`jq -r '.CDMailPrefixName' "$input_file"`
    CalendarPrefixName=`jq -r '.CalendarPrefixName' "$input_file"`
    DSPrefixName=`jq -r '.DSPrefixName' "$input_file"`
    ProjectsPrefixName=`jq -r '.ProjectsPrefixName' "$input_file"`
    PagesPrefixName=`jq -r '.PagesPrefixName' "$input_file"`
    FormsPrefixName=`jq -r '.FormsPrefixName' "$input_file"`
    CDDiskDatabaseType="postgresql"
    echo "MakeCleanInstall: $MakeCleanInstall"
    echo "InstallPostgresServer: $InstallPostgresServer"
    echo "InstallDocumentServer: $InstallDocumentServer"
    echo "DocumentServerJWTkey: $DocumentServerJWTkey"
    echo "DocumentServerDBPassword: *****"
    echo "ExternalDocumentServerDomain: $ExternalDocumentServerDomain"
    echo "InstallCDDisk: $InstallCDDisk"
    echo "CDDiskDatabaseType: $CDDiskDatabaseType"
    echo "CDDiskCreateDatabase: $CDDiskCreateDatabase"
    echo "CDDiskDatabaseHost: $CDDiskDatabaseHost"
    echo "CDDiskDatabasePort: $CDDiskDatabasePort"
    echo "CDDiskDatabaseCreateUser: $CDDiskDatabaseCreateUser"
    echo "CDDiskDatabaseUser: $CDDiskDatabaseUser"
    echo "CDDiskDatabaseName: $CDDiskDatabaseName"
    echo "CDDiskDatabasePassword: *****"
    echo "CDDiskDatabaseCreatePassword: *****"
    echo "CDDiskSaltKey: $CDDiskSaltKey"
    echo "CDDiskMakeHTTPS: $CDDiskMakeHTTPS"
    echo "CDDiskDomainName: $CDDiskDomainName"
    echo "CDDiskPrefixName: $CDDiskPrefixName"
    echo "AdminPrefixName: $AdminPrefixName"
    echo "ContactsPrefixName: $ContactsPrefixName"
    echo "CDMailPrefixName: $CDMailPrefixName"
    echo "CalendarPrefixName: $CalendarPrefixName"
    echo "DSPrefixName: $DSPrefixName"
    echo "ProjectsPrefixName: $ProjectsPrefixName"
    echo "PagesPrefixName: $PagesPrefixName"
    echo "FormsPrefixName: $FormsPrefixName"

    if [ "$MakeCleanInstall" = "true" ]; then
	fn_make_clean_install
	if ! [ $resultFunc = 0 ]; then
	    echo "Error $resultFunc. Exit installation."
	    fn_result_print
	    return $resultFunc
        fi
    fi

    fn_install_rabbitmq
    if ! [ $resultFunc = 0 ]; then
	echo "Error $resultFunc. Exit installation."
	fn_result_print
        return $resultFunc
    fi
    if [ -f /var/tmp/r7mkpg ]; then
        sudo rm -f /var/tmp/r7mkpg
    fi

    if [ "$InstallPostgresServer" = "true" ]; then
	fn_install_pg_server
	if ! [ $resultFunc = 0 ]; then
	    echo "Error $resultFunc. Exit installation."
	    fn_result_print
	    return $resultFunc
        fi
    else
	fn_install_pg_client
	if ! [ $resultFunc = 0 ]; then
	    echo "Error $resultFunc. Exit installation."
	    fn_result_print
	    return $resultFunc
        fi
    fi
    echo "RES=$resultFunc"

    if [ -e /etc/astra_version ]; then
	fn_install_astra
	if ! [ $resultFunc = 0 ]; then
	    echo "Error $resultFunc. Exit installation."
	    fn_result_print
	    return $resultFunc
        fi
    fi

    if [ "$InstallDocumentServer" = "true" ]; then
	jwt_token=$DocumentServerJWTkey
        if [ -z "$jwt_token" ]; then
	    jwt_token=$(cat /dev/urandom | tr -dc A-Za-z0-9 | head -c 12)
	    echo "Random secret generated."
        fi
	DocumentServerJWTkey=$jwt_token
	fn_install_ds_local
	if ! [ $resultFunc = 0 ]; then
	    echo "Error $resultFunc. Exit installation."
	    fn_result_print
	    return $resultFunc
        fi
    else
	echo "external DS URL: $ExternalDocumentServerDomain"

	EXTERNAL_DS_JWT_KEY=$DocumentServerJWTkey
        if [ -z "$EXTERNAL_DS_JWT_KEY" ]; then
	    EXTERNAL_DS_JWT_KEY=$(cat /dev/urandom | tr -dc A-Za-z0-9 | head -c 12)
	    echo "Random secret generated."
        fi
	echo "external DS JWT-key: $EXTERNAL_DS_JWT_KEY"
	DocumentServerJWTkey=$EXTERNAL_DS_JWT_KEY

	fn_install_ds_external
	if ! [ $resultFunc = 0 ]; then
	    echo "Error $resultFunc. Exit installation."
	    fn_result_print
	    return $resultFunc
        fi
    fi

    sudo sed -i 's/\"savetimeoutdelay\":\ 5000/\"savetimeoutdelay\":\ 1000/g' /etc/r7-office/documentserver/default.json

    if [ "$InstallCDDisk" = "true" ]; then
	echo cddisk cddisk/fromscript boolean true | sudo debconf-set-selections
	echo cddisk cddisk/db-type select $CDDiskDatabaseType | sudo debconf-set-selections
	echo cddisk cddisk/db-create boolean $CDDiskCreateDatabase | sudo debconf-set-selections
	echo cddisk cddisk/db-host string $CDDiskDatabaseHost | sudo debconf-set-selections
	echo cddisk cddisk/db-port-postgresql string $CDDiskDatabasePort | sudo debconf-set-selections
	echo cddisk cddisk/db-user string $CDDiskDatabaseUser | sudo debconf-set-selections
	echo cddisk cddisk/db-pwd string $CDDiskDatabasePassword | sudo debconf-set-selections
	echo cddisk cddisk/db-name string $CDDiskDatabaseName | sudo debconf-set-selections
	echo cddisk cddisk/db-create-user string $CDDiskDatabaseCreateUser | sudo debconf-set-selections
	echo cddisk cddisk/db-create-pwd string $CDDiskDatabaseCreatePassword | sudo debconf-set-selections
	echo cddisk cddisk/core-machine-key string $CDDiskSaltKey | sudo debconf-set-selections
	echo cddisk cddisk/make-https boolean $CDDiskMakeHTTPS | sudo debconf-set-selections
	echo cddisk cddisk/site-domain string $CDDiskDomainName | sudo debconf-set-selections
	echo cddisk cddisk/cddisk-name string $CDDiskPrefixName | sudo debconf-set-selections
	echo cddisk cddisk/admin-name string $AdminPrefixName | sudo debconf-set-selections
	echo cddisk cddisk/contacts-name string $ContactsPrefixName | sudo debconf-set-selections
	echo cddisk cddisk/cdmail-name string $CDMailPrefixName | sudo debconf-set-selections
	echo cddisk cddisk/calendar-name string $CalendarPrefixName | sudo debconf-set-selections
	echo cddisk cddisk/projects-name string $ProjectsPrefixName | sudo debconf-set-selections
	echo cddisk cddisk/pages-name string $PagesPrefixName | sudo debconf-set-selections
	echo cddisk cddisk/forms-name string $FormsPrefixName | sudo debconf-set-selections
	echo cddisk cddisk/ds-name string $DSPrefixName | sudo debconf-set-selections
	fn_install_cddisk
	if ! [ $resultFunc = 0 ]; then
	    echo "Error $resultFunc. Exit installation."
	    fn_result_print
	    return $resultFunc
        fi
    fi
    fn_result_print
else
    echo "Install params from keyboard."

	MakeCleanInstall="false"
    if (whiptail --title "cddisk" --yesno "Make clean install?" 10 60); then
	MakeCleanInstall="true"
	fn_make_clean_install
	if ! [ $resultFunc = 0 ]; then
	    echo "Error $resultFunc. Exit installation."
	    fn_result_print
	    return $resultFunc
        fi
    fi

    fn_install_rabbitmq
    if ! [ $resultFunc = 0 ]; then
	echo "Error $resultFunc. Exit installation."
	fn_result_print
        return $resultFunc
    fi
    if [ -f /var/tmp/r7mkpg ]; then
        sudo rm -f /var/tmp/r7mkpg
    fi

    if (whiptail --title "cddisk" --yesno "Install postgresql server on local pc?" 10 60); then
	InstallPostgresServer="true"
	fn_install_pg_server
	if ! [ $resultFunc = 0 ]; then
	    echo "Error $resultFunc. Exit installation."
	    fn_result_print
	    return $resultFunc
        fi
    else
	InstallPostgresServer="false"
	fn_install_pg_client
	if ! [ $resultFunc = 0 ]; then
	    echo "Error $resultFunc. Exit installation."
	    fn_result_print
	    return $resultFunc
        fi
    fi

    if (whiptail --title "cddisk" --yesno "Install Document Server?" 10 60); then
	InstallDocumentServer="true"
    else
	InstallDocumentServer="false"
    fi

    if [ -e /etc/astra_version ]; then
	fn_install_astra
	if ! [ $resultFunc = 0 ]; then
	    echo "Error $resultFunc. Exit installation."
	    fn_result_print
	    return $resultFunc
        fi
    fi

    if [ "true" = "$InstallDocumentServer" ]; then
	jwt_token=$(whiptail --title "cddisk" --ok-button "OK" --cancel-button "Cancel" --passwordbox "Document Server secret:" 10 60 "" 3>&1 1>&2 2>&3)
        if ! [ $? = 0 ] || [ -z "$jwt_token" ]; then
	    jwt_token=$(cat /dev/urandom | tr -dc A-Za-z0-9 | head -c 12)
	    echo "Random secret generated."
        fi
	DocumentServerJWTkey=jwt_token

	INTERNAL_DS_DB_PWD=$(whiptail --title  "cddisk" --passwordbox  "Document Server Database password:" 10 60 "" 3>&1 1>&2 2>&3)
	exitstatus=$?
	if [ $exitstatus = 0 ];  then
	    echo "DS Database password: ********"
	else
	    INTERNAL_DS_DB_PWD="saSA123$"
	    echo "DS Database password: ********"
	fi
	DocumentServerDBPassword=$INTERNAL_DS_DB_PWD
	
	fn_install_ds_local
	if ! [ $resultFunc = 0 ]; then
	    echo "Error $resultFunc. Exit installation."
	    fn_result_print
	    return $resultFunc
        fi
    else
	EXTERNAL_DS_DOMAIN=$(whiptail --title  "cddisk" --inputbox  "Document Server URL:" 10 60 http://local.ru:8083 3>&1 1>&2 2>&3)
	exitstatus=$?
	if [ $exitstatus = 0 ];  then
	    echo "external DS URL: $EXTERNAL_DS_DOMAIN"
	else
	    EXTERNAL_DS_DOMAIN="local.ru"
	    echo "external DS URL: $EXTERNAL_DS_DOMAIN"
	fi

	EXTERNAL_DS_JWT_KEY=$(whiptail --title  "cddisk" --inputbox  "Document Server JWT key:" 10 60 jwt-key 3>&1 1>&2 2>&3)
	exitstatus=$?
	if [ $exitstatus = 0 ];  then
	    echo "external DS JWT-key: $EXTERNAL_DS_JWT_KEY"
	else
	    EXTERNAL_DS_JWT_KEY=$(cat /dev/urandom | tr -dc A-Za-z0-9 | head -c 12)
	    echo "external DS JWT-key: $EXTERNAL_DS_JWT_KEY"
	fi
	DocumentServerJWTkey=$EXTERNAL_DS_JWT_KEY

	DocumentServerJWTkey
	fn_install_ds_external
	if ! [ $resultFunc = 0 ]; then
	    echo "Error $resultFunc. Exit installation."
	    fn_result_print
	    return $resultFunc
        fi
    fi

    sudo sed -i 's/\"savetimeoutdelay\":\ 5000/\"savetimeoutdelay\":\ 1000/g' /etc/r7-office/documentserver/default.json

    if (whiptail --title "cddisk" --yesno "Install CDDisk api & web?" 10 60); then

#	db_type=$(whiptail --title  "cddisk" --menu "Choose database type:" 15 60 2 "postgresql" "" "mssql" "" 3>&1 1>&2 2>&3)
#	exitstatus=$?
#	if [ $exitstatus != 0 ];  then
#	    echo "Default"
#	    db_type="postgresql"
#	fi
	CDDiskDatabaseType="postgresql"
	echo "DB Type: $CDDiskDatabaseType"

	if (whiptail --title "cddisk" --yesno "Create database?" 10 60 3>&1 1>&2 2>&3); then
	    CDDiskCreateDatabase="true"
	else
	    CDDiskCreateDatabase="false"
	fi
	echo "DB Create: $CDDiskCreateDatabase"

	CDDiskDatabaseHost=$(whiptail --title  "cddisk" --inputbox "Database host:" 10 60 "localhost" 3>&1 1>&2 2>&3)
	exitstatus=$?
	if [ $exitstatus != 0 ];  then
	    CDDiskDatabaseHost="localhost"
	fi
	echo "DB Host: $CDDiskDatabaseHost"

	case $CDDiskDatabaseType in
	    "postgresql")
		CDDiskDatabasePort=$(whiptail --title  "cddisk" --inputbox "Database port:" 10 60 "5432" 3>&1 1>&2 2>&3)
		exitstatus=$?
		if [ $exitstatus != 0 ];  then
		    CDDiskDatabasePort="5432"
		fi
		echo "DB Port: $CDDiskDatabasePort"
		;;
	    "mssql")
		CDDiskDatabasePort=$(whiptail --title  "cddisk" --inputbox "Database port:" 10 60 "1433" 3>&1 1>&2 2>&3)
		exitstatus=$?
		if [ $exitstatus != 0 ];  then
		    CDDiskDatabasePort="1433"
		fi
		echo "DB Port: $CDDiskDatabasePort"
		;;
	    *)
		CDDiskDatabasePort=$(whiptail --title  "cddisk" --inputbox "Database port:" 10 60 "5432" 3>&1 1>&2 2>&3)
		exitstatus=$?
		if [ $exitstatus != 0 ];  then
		    CDDiskDatabasePort="5432"
		fi
		echo "DB Port: $CDDiskDatabasePort"
		;;
	esac

	CDDiskDatabaseName=$(whiptail --title  "cddisk" --inputbox  "Database name:" 10 60 cddisk 3>&1 1>&2 2>&3)
	exitstatus=$?
	if [ $exitstatus != 0 ];  then
	    CDDiskDatabaseName="cddisk"
	fi
	echo "DB name: $CDDiskDatabaseName"

	CDDiskDatabaseCreateUser=$(whiptail --title  "cddisk" --inputbox  "Database user for create DB:" 10 60 postgres 3>&1 1>&2 2>&3)
	exitstatus=$?
	if [ $exitstatus != 0 ];  then
	    CDDiskDatabaseCreateUser="postgres"
	fi
	echo "DB create user: $CDDiskDatabaseCreateUser"

	CDDiskDatabaseUser=$(whiptail --title  "cddisk" --inputbox "Database user:" 10 60 "cddisk" 3>&1 1>&2 2>&3)
	exitstatus=$?
	if [ $exitstatus != 0 ];  then
	    CDDiskDatabaseUser="cddisk"
	fi
	echo "DB User: $CDDiskDatabaseUser"

	CDDiskDatabaseCreatePassword=$(whiptail --title  "cddisk" --passwordbox "Database password for create DB:" 10 60 "" 3>&1 1>&2 2>&3)
	exitstatus=$?
	if [ $exitstatus != 0 ];  then
	    CDDiskDatabaseCreatePassword="saSA123$"
	fi
	echo "DB Password for create DB: ********"

	CDDiskDatabasePassword=$(whiptail --title  "cddisk" --passwordbox "Database password for user:" 10 60 "" 3>&1 1>&2 2>&3)
	exitstatus=$?
	if [ $exitstatus != 0 ];  then
	    CDDiskDatabasePassword="saSA123$"
	fi
	echo "DB Password: ********"

	CDDiskSaltKey=$(whiptail --title  "cddisk" --inputbox "The salt to be used during the key derivation process:" 10 60 "Vskoproizvolny Salt par Chivreski" 3>&1 1>&2 2>&3)
	exitstatus=$?
	if [ $exitstatus != 0 ];  then
	    CDDiskSaltKey="Vskoproizvolny Salt par Chivreski"
	fi
	echo "Core machine key: $CDDiskSaltKey"

	if (whiptail --title "cddisk" --yesno "Make https?" 10 60 3>&1 1>&2 2>&3); then
	    CDDiskMakeHTTPS="true"
	else
	    CDDiskMakeHTTPS="false"
	fi
	echo "Make HTTPS access to site: $CDDiskMakeHTTPS"

	CDDiskDomainName=$(whiptail --title  "cddisk" --inputbox "Domain name:" 10 60 "local.ru" 3>&1 1>&2 2>&3)
	exitstatus=$?
	if [ $exitstatus != 0 ];  then
	    CDDiskDomainName="local.ru"
	fi
	echo "Domain name: $CDDiskDomainName"

	CDDiskPrefixName=$(whiptail --title  "cddisk" --inputbox "Prefix name for cddisk:" 10 60 "cddisk" 3>&1 1>&2 2>&3)
	exitstatus=$?
	if [ $exitstatus != 0 ];  then
	    CDDiskPrefixName="cddisk"
	fi
	echo "Prefix name for cddisk: $CDDiskPrefixName"

	AdminPrefixName=$(whiptail --title  "cddisk" --inputbox "Prefix name for admin:" 10 60 "admin" 3>&1 1>&2 2>&3)
	exitstatus=$?
	if [ $exitstatus != 0 ];  then
	    AdminPrefixName="admin"
	fi
	echo "Prefix name for admin: $AdminPrefixName"

	ContactsPrefixName=$(whiptail --title  "cddisk" --inputbox "Prefix name for contacts:" 10 60 "contacts" 3>&1 1>&2 2>&3)
	exitstatus=$?
	if [ $exitstatus != 0 ];  then
	    ContactsPrefixName="contacts"
	fi
	echo "Prefix name for contacts: $ContactsPrefixName"

	ProjectsPrefixName=$(whiptail --title  "cddisk" --inputbox "Prefix name for projects:" 10 60 "projects" 3>&1 1>&2 2>&3)
	exitstatus=$?
	if [ $exitstatus != 0 ];  then
	    ProjectsPrefixName="projects"
	fi
	echo "Prefix name for projects: $ProjectsPrefixName"

	PagesPrefixName=$(whiptail --title  "cddisk" --inputbox "Prefix name for pages:" 10 60 "pages" 3>&1 1>&2 2>&3)
	exitstatus=$?
	if [ $exitstatus != 0 ];  then
	    PagesPrefixName="pages"
	fi
	echo "Prefix name for pages: $PagesPrefixName"

	FormsPrefixName=$(whiptail --title  "cddisk" --inputbox "Prefix name for forms:" 10 60 "forms" 3>&1 1>&2 2>&3)
	exitstatus=$?
	if [ $exitstatus != 0 ];  then
	    FormsPrefixName="forms"
	fi
	echo "Prefix name for forms: $FormsPrefixName"

	if [ -f cddisk-calendar*.deb ] && [ -f cdmail*.deb ]; then
	    CDMailPrefixName=$(whiptail --title  "cddisk" --inputbox "Prefix name for cdmail:" 10 60 "cdmail" 3>&1 1>&2 2>&3)
	    exitstatus=$?
	    if [ $exitstatus != 0 ];  then
		CDMailPrefixName="cdmail"
	    fi
	    echo "Prefix name for cdmail: $CDMailPrefixName"

	    CalendarPrefixName=$(whiptail --title  "cddisk" --inputbox "Prefix name for calendar:" 10 60 "calendar" 3>&1 1>&2 2>&3)
	    exitstatus=$?
	    if [ $exitstatus != 0 ];  then
		CalendarPrefixName="calendar"
	    fi
	    echo "Prefix name for calendar: $CalendarPrefixName"
	fi

	DSPrefixName=$(whiptail --title  "cddisk" --inputbox "Prefix name for DS:" 10 60 "ds" 3>&1 1>&2 2>&3)
	exitstatus=$?
	if [ $exitstatus != 0 ];  then
	    DSPrefixName="ds"
	fi
	echo "Prefix name for DS: $DSPrefixName"

        if [ $CDDiskMakeHTTPS = "true" ]; then
	    if ! [ -f ./../sslcert/$CDDiskDomainName.crt ] || ! [ -f ./../sslcert/$CDDiskDomainName.key ]; then
	    whiptail --title "cddisk" --msgbox "Certificates not found in sslcert dir. Exit installation..." 10 60
	    sudo rm -r /var/tmp/sslcert
	    echo "failed" > /var/tmp/error
	    return 120
	    fi
        fi
	echo cddisk cddisk/fromscript boolean true | sudo debconf-set-selections
	echo cddisk cddisk/db-type select $CDDiskDatabaseType  | sudo debconf-set-selections
	echo cddisk cddisk/db-create boolean $CDDiskCreateDatabase | sudo debconf-set-selections
	echo cddisk cddisk/db-host string $CDDiskDatabaseHost | sudo debconf-set-selections
	echo cddisk cddisk/db-port-postgresql string $CDDiskDatabasePort | sudo debconf-set-selections
	echo cddisk cddisk/db-user string $CDDiskDatabaseUser | sudo debconf-set-selections
	echo cddisk cddisk/db-pwd string $CDDiskDatabasePassword | sudo debconf-set-selections
	echo cddisk cddisk/db-name string $CDDiskDatabaseName | sudo debconf-set-selections
	echo cddisk cddisk/db-create-user string $CDDiskDatabaseCreateUser | sudo debconf-set-selections
	echo cddisk cddisk/db-create-pwd string $CDDiskDatabaseCreatePassword | sudo debconf-set-selections
	echo cddisk cddisk/core-machine-key string $CDDiskSaltKey | sudo debconf-set-selections
	echo cddisk cddisk/make-https boolean $CDDiskMakeHTTPS | sudo debconf-set-selections
	echo cddisk cddisk/site-domain string $CDDiskDomainName | sudo debconf-set-selections
	echo cddisk cddisk/cddisk-name string $CDDiskPrefixName | sudo debconf-set-selections
	echo cddisk cddisk/admin-name string $AdminPrefixName | sudo debconf-set-selections
	echo cddisk cddisk/contacts-name string $ContactsPrefixName | sudo debconf-set-selections
	echo cddisk cddisk/cdmail-name string $CDMailPrefixName | sudo debconf-set-selections
	echo cddisk cddisk/calendar-name string $CalendarPrefixName | sudo debconf-set-selections
	echo cddisk cddisk/projects-name string $ProjectsPrefixName | sudo debconf-set-selections
	echo cddisk cddisk/pages-name string $PagesPrefixName | sudo debconf-set-selections
	echo cddisk cddisk/forms-name string $FormsPrefixName | sudo debconf-set-selections
	echo cddisk cddisk/ds-name string $DSPrefixName | sudo debconf-set-selections
	fn_install_cddisk
	if ! [ $resultFunc = 0 ]; then
	    echo "Error $resultFunc. Exit installation."
	    fn_result_print
	    return $resultFunc
	fi
    fi
    fn_result_print
fi
}

fn_install()
{
    fn_detect_os
    fn_fill_apt_sorces
    fn_install_tools
    fn_install_ms_fonts

    fn_main_install
    if [ $resultFunc = 0 ]; then
	fn_post_cddisk_install
	echo "CDDisk setup complete."

	chmod +x checkhealth.sh
	./checkhealth.sh

	chmod +x install_mailserver.sh
	bash ./install_mailserver.sh
    else
	echo "CDDisk setup failed. Exit code $resultFunc"
    fi
}

fn_install 2>&1 | tee -a logfile.txt
