DO $$ 
    BEGIN
        BEGIN
           IF EXISTS (SELECT "Id" FROM public."Versions" WHERE "Build">=1765) THEN
		RETURN;
          END IF;

	   CREATE TABLE public."SharedLinksNew2" (
    "Id" bigserial NOT NULL,
    "Uid" character varying(64) NOT NULL,
    "Hash" character varying(64) NOT NULL,
    "EntityId" bigint NOT NULL,
    "EntityType" integer NOT NULL,
    "LifeTime" integer NOT NULL,
    "UserId" bigint NOT NULL,
    "AccessType" integer NOT NULL,
    "Timestamp" timestamp without time zone DEFAULT timezone('utc', now())  NOT NULL,
    "Password" character varying(500) NULL,
    "ExpirationDate" timestamp NULL,
     CONSTRAINT "PK_SharedLinksNew2" PRIMARY KEY ("Hash")
); 

CREATE INDEX "IDX_SharedLinks_All"
    ON public."SharedLinksNew2" USING btree
    ("Uid" ASC NULLS LAST, "EntityId" ASC NULLS LAST, "EntityType" ASC NULLS LAST, "LifeTime" ASC NULLS LAST, "UserId" ASC NULLS LAST, "AccessType" ASC NULLS LAST)
    TABLESPACE pg_default;  

CREATE INDEX "IDX_SharedLinks_Id"
    ON public."SharedLinksNew2" USING btree
    ("Id" ASC NULLS LAST)
    TABLESPACE pg_default; 

INSERT INTO public."SharedLinksNew2"
           ("Uid","Hash"
           ,"EntityId"
           ,"EntityType"
           ,"LifeTime"
           ,"UserId"
           ,"AccessType"
           ,"Password"
      ,"ExpirationDate","Timestamp")
    SELECT "Uid","Uid"
           ,"EntityId"
           ,"EntityType"
           ,"LifeTime"
           ,"UserId"
           ,"AccessType","Password"
      ,"ExpirationDate"
           ,"Timestamp" FROM public."SharedLinks" WHERE "LifeTime" IN(10,11);

ALTER TABLE public."SharedLinks" RENAME TO "SharedLinksOld3";

ALTER TABLE public."SharedLinksNew2" RENAME TO "SharedLinks";

        EXCEPTION
            WHEN duplicate_column THEN RAISE NOTICE 'Recreate <SharedLinks>.';
        END;
    END;
$$

