
DO $$ 
    BEGIN
         IF EXISTS (SELECT "Id" FROM public."Versions" WHERE "Build">=1765) THEN
		RETURN;
          END IF;
 
        BEGIN
    CREATE TABLE public."CustomerQuota" (
	"Id" BIGSERIAL NOT NULL, 
	"TenantId" BIGINT NOT NULL,
	"Name" character varying(1024) NULL,
	"Description" character varying(4000) NULL,
	"MaxFileSize" BIGINT NOT NULL,
	"MaxTotalSize" BIGINT NOT NULL,
	"ActiveUsers" BIGINT NOT NULL,
	"Features" character varying(4000) NULL, 
	"Price" FLOAT NOT NULL,
	"TotalPrice" FLOAT NOT NULL, 
        "Visible" INT DEFAULT 1 NOT NULL,   
	"Timestamp" timestamp without time zone DEFAULT timezone('utc', now())  NOT NULL,
CONSTRAINT "PK_CustomerQuota" PRIMARY KEY ("TenantId")
);



        EXCEPTION
            WHEN duplicate_table THEN RAISE NOTICE 'Create table <CustomerQuota>.';
        END;
    END;
$$




