DO $$ 
    BEGIN
          IF EXISTS (SELECT "Id" FROM public."Versions" WHERE "Build">=2772) THEN
		RETURN;
          END IF;
        BEGIN

       	  

CREATE TABLE IF NOT EXISTS public."ProjectTasks"
(
    "Id" bigserial NOT NULL,
    "TypeId" bigint NOT NULL,
    "ParentId" bigint,
    "AuthorId" bigint NOT NULL,
    "PerformerId" bigint,
    "PerformerRoleId" bigint,
    "Priority" integer NOT NULL,
    "Status" integer NOT NULL,
    "Key" character varying(128)  NOT NULL,
    "Title" character varying(500)  NOT NULL,
    "Description" text COLLATE pg_catalog."default",
    "ProjectId" bigint NOT NULL,
    "SprintId" bigint,
    "Updated" timestamp without time zone,
    "Estimated" bigint,
    "TimeLeft" bigint,
    "TimeSpent" bigint,
    "HasLinks" boolean DEFAULT false,
    "HasAttributes" boolean DEFAULT false,
    "Timestamp" timestamp without time zone NOT NULL DEFAULT timezone('utc'::text, now()),
    "HasAttachments" boolean DEFAULT false,
    CONSTRAINT "ProjectTasks_pkey" PRIMARY KEY ("Id")
);

 

CREATE INDEX IF NOT EXISTS "IDX_ProjectTasks-Key"
    ON public."ProjectTasks" USING btree
    ("Key" COLLATE pg_catalog."default" ASC NULLS LAST)
    TABLESPACE pg_default;
 

CREATE INDEX IF NOT EXISTS "IDX_ProjectTasks-ProjectId-AuthorId-All"
    ON public."ProjectTasks" USING btree
    ("ProjectId" ASC NULLS LAST, "SprintId" ASC NULLS LAST, "ParentId" ASC NULLS LAST, "AuthorId" ASC NULLS LAST, "PerformerId" ASC NULLS LAST, "TypeId" ASC NULLS LAST, "Priority" ASC NULLS LAST, "Updated" ASC NULLS LAST, "Status" ASC NULLS LAST)
    TABLESPACE pg_default;

        EXCEPTION
            WHEN OTHERS THEN RAISE NOTICE 'Create table ProjectTasks error.';
        END;
    END;
$$
