DO $$ 
  BEGIN
    IF EXISTS (SELECT "Id" FROM public."Versions" WHERE "Build">=3351) THEN
      RETURN;
    END IF;
    BEGIN

-- BEGIN

    CREATE TABLE public."EventEmailInviteStatus" (
      "Id" bigserial PRIMARY KEY,
      "MessageId" bigint NOT NULL,
      "AttachmentId" bigint NOT NULL,
      "EventDetailId" bigint NOT NULL,
      "Sequence" int2,
      "Method" integer NOT NULL,
      "LastModificationDate" timestamp without time zone DEFAULT timezone('utc', now()) NOT NULL
    );

    CREATE INDEX "IDX_EventInviteDetails_MessageId"
      ON public."EventEmailInviteStatus" USING btree
      ("MessageId" ASC NULLS LAST)
      TABLESPACE pg_default; 

    CREATE INDEX "IDX_EventInviteDetails_EventDetailId"
      ON public."EventEmailInviteStatus" USING btree
      ("EventDetailId" ASC NULLS LAST)
      TABLESPACE pg_default;

-- END

    EXCEPTION
        WHEN OTHERS THEN RAISE NOTICE 'Create table EventEmailInviteStatus error.';
    END;
  END;
$$
