DO $$ 
	DECLARE _path character varying(256) = 'patch-2024-09-03-EmailAttachments-MimeType';

	BEGIN
		IF EXISTS (SELECT "Id" FROM public."Versions" WHERE "Path"=_path) THEN
			RETURN;
		END IF;

		IF EXISTS (SELECT "Id" FROM public."Versions" WHERE "Build">=4490) THEN
			RETURN;
		END IF;

		BEGIN
		ALTER TABLE public."EmailAttachments" ADD "MimeTypeNew" character varying(512);
		UPDATE public."EmailAttachments" SET "MimeTypeNew" = "MimeType";
		ALTER TABLE public."EmailAttachments" DROP "MimeType";
		ALTER TABLE public."EmailAttachments" RENAME "MimeTypeNew" TO "MimeType";

 
		INSERT INTO public."Versions" ("Path", "Build") VALUES (_path, 0);

			EXCEPTION
				WHEN OTHERS THEN RAISE NOTICE '[ERR] patch-2024-09-03-EmailAttachments-MimeType: %', SQLERRM;
		END;
	END;
$$
