
DO $$ 
DECLARE _path character varying(256) = 'patch-2024-11-02-GroupEntityRelations';

    BEGIN
         IF EXISTS (SELECT "Id" FROM public."Versions" WHERE "Build">=14592) THEN
		RETURN;
          END IF;
 

	IF EXISTS (SELECT "Id" FROM public."Versions" WHERE "Path"=_path) THEN
			RETURN;
	END IF;


        BEGIN
  

		DROP TABLE public."GroupUserRepations";
		CREATE TABLE public."GroupEntityRelations" (
    			"Id" bigserial,
    			"EntityId" bigint not null,
    			"GroupId" bigint not null,
    			"CreatedAt" timestamp without time zone DEFAULT timezone('utc', now())  NOT NULL,
    			CONSTRAINT "GroupEntityRelations_pkey" PRIMARY KEY ("EntityId","GroupId")
			);

		CREATE INDEX IF NOT EXISTS "IDX_GroupEntityRelations-GroupId-Id"
    			ON public."GroupEntityRelations" USING btree
    			("GroupId" ASC NULLS LAST, "Id" ASC NULLS LAST)
    			TABLESPACE pg_default;

 			INSERT INTO public."Versions" ("Path", "Build") VALUES (_path, 0);
  
        EXCEPTION
            WHEN duplicate_table THEN RAISE NOTICE 'Can not Create table <GroupEntityRelations>.';
        END;
    END;
$$








