
DO $$ 
DECLARE _path character varying(256) = 'patch-2024_12_16_ProjectUserMentions';

    BEGIN
         IF EXISTS (SELECT "Id" FROM public."Versions" WHERE "Build">=14592) THEN
		RETURN;
          END IF;
 

	IF EXISTS (SELECT "Id" FROM public."Versions" WHERE "Path"=_path) THEN
		RETURN;
	END IF;


        BEGIN
  

CREATE TABLE IF NOT EXISTS public."ProjectUserMentions"
(
    "Id" bigserial NOT NULL,
    "EntityId" bigint NOT NULL,
    "ProjectId" bigint NOT NULL,
    "TaskId" bigint NOT NULL,
    "OwnerId" bigint NOT NULL,
    "UserId" bigint NOT NULL,
    "EntityType" integer NOT NULL,
    "Timestamp" timestamp without time zone NOT NULL DEFAULT timezone('utc'::text, now()),
    CONSTRAINT "ProjectUserMentions_pkey" PRIMARY KEY ("Id")
);


CREATE INDEX IF NOT EXISTS "IDX_ProjectUserMentions-EntityId"
    ON public."ProjectUserMentions" USING btree
    ("EntityId" ASC NULLS LAST, "EntityType" ASC NULLS LAST)
    TABLESPACE pg_default;
 
CREATE INDEX IF NOT EXISTS "IDX_ProjectUserMentions-OwnerId-TaskId-ProjectId"
    ON public."ProjectUserMentions" USING btree
    ("OwnerId" ASC NULLS LAST, "ProjectId" ASC NULLS LAST, "TaskId" ASC NULLS LAST)
    TABLESPACE pg_default;

 			INSERT INTO public."Versions" ("Path", "Build") VALUES (_path, 0);
  
		EXCEPTION
		WHEN OTHERS THEN RAISE NOTICE '[ERR] patch-2024_12_16_ProjectUserMentions: %', SQLERRM;
        END;
    END;
$$
