DO $$ 
	DECLARE _path character varying(256) = 'patch-2024-11-28-Projects_UpdateKeyA';

	BEGIN
		IF EXISTS (SELECT "Id" FROM public."Versions" WHERE "Path"=_path) THEN
			RETURN;
		END IF;

		IF EXISTS (SELECT "Id" FROM public."Versions" WHERE "Build">=14592) THEN
			RETURN;
		END IF;

		BEGIN
            		update public."Projects" set "Key"=replace("Key", 'А', 'A') where "Key" ILIKE '%А%';
            		update public."ProjectTasks" set "Key"=replace("Key", 'А', 'A') where "Key" ILIKE '%А%';

 			INSERT INTO public."Versions" ("Path", "Build") VALUES (_path, 0);
			EXCEPTION
				WHEN OTHERS THEN RAISE NOTICE '[ERR] patch-2024-11-28-Projects_UpdateKeyA: %', SQLERRM;
		END;
	END;
$$