DO $$ 
	DECLARE _path character varying(256) = 'patch-2025_05_18-UserActionDescriptions';

	BEGIN
		IF EXISTS (SELECT "Id" FROM public."Versions" WHERE "Path"=_path) THEN
			RETURN;
		END IF;

		IF EXISTS (SELECT "Id" FROM public."Versions" WHERE "Build">=14984) THEN
			RETURN;
		END IF;

		BEGIN
			CREATE TABLE public."UserActionDescriptions" (
				"ActionId" bigint,
				"Culture" character varying(20),
				"Description" character varying(500),
				PRIMARY KEY ("ActionId", "Culture")
			);

			CREATE INDEX "IDX_UserActionDescriptions_ActionId_Culture"
				ON public."UserActionDescriptions" USING btree
				("ActionId" ASC NULLS LAST, "Culture" ASC NULLS LAST)
				TABLESPACE pg_default;             

			INSERT INTO public."Versions" ("Path", "Build") VALUES (_path, 0);
			EXCEPTION
				WHEN OTHERS THEN RAISE NOTICE '[ERR] patch-2025_05_18-UserActionDescriptions: %', SQLERRM;


		END;
	END;
$$