DO $$ 
	DECLARE _path character varying(256) = 'patch-2025_06_12-FlexibleTableFields';

	BEGIN
		IF EXISTS (SELECT "Id" FROM public."Versions" WHERE "Path"=_path) THEN
			RETURN;
		END IF;

		IF EXISTS (SELECT "Id" FROM public."Versions" WHERE "Build">=15113) THEN
			RETURN;
		END IF;

		BEGIN
            		

CREATE TABLE IF NOT EXISTS public."FlexibleTableFields"
(
    "Id" bigserial NOT NULL,
    "Name" character varying(1000) NOT NULL,
    "Pattern" character varying(1000) NULL,
    "Format" character varying(1000) NULL,
    "TableId" bigint NOT NULL,
    "Type" integer NOT NULL DEFAULT 0,
    "ViewType" integer NOT NULL DEFAULT 1,
    "Timestamp" timestamp without time zone NOT NULL DEFAULT timezone('utc'::text, now()),
    CONSTRAINT "FlexibleTableFields_pkey" PRIMARY KEY ("Name", "TableId")
);

CREATE INDEX IF NOT EXISTS "IDX_FlexibleTableFields-TableId"
    ON public."FlexibleTableFields" USING btree
    ("TableId" ASC NULLS LAST)
    TABLESPACE pg_default;			
 			INSERT INTO public."Versions" ("Path", "Build") VALUES (_path, 0);
			EXCEPTION
				WHEN OTHERS THEN RAISE NOTICE '[ERR] patch-2025_06_12-FlexibleTableFields: %', SQLERRM;
		END;
	END;
$$
