DO $$
	DECLARE _path character varying(256) = 'patch-2025_08_06-FlexibleFieldDate';

	BEGIN
		IF EXISTS (SELECT "Id" FROM public."Versions" WHERE "Path"=_path) THEN
			RETURN;
		END IF;

		IF EXISTS (SELECT "Id" FROM public."Versions" WHERE "Build">=15232) THEN
			RETURN;
		END IF;

		BEGIN
		CREATE TABLE public."FlexibleFieldDate" (
			"Id" bigserial,
			"TableId" bigint NOT NULL,
			"FieldId" bigint NOT NULL,
			"EntityId" bigint NOT NULL,
			"Value" timestamp without time zone NULL,
			"Timestamp" timestamp without time zone DEFAULT timezone('utc', now())  NOT NULL,
			CONSTRAINT "FlexibleFieldDate_pkey" PRIMARY KEY ("FieldId","EntityId")
		);
		CREATE INDEX IF NOT EXISTS "IDX_FlexibleFieldDate-TableId"
			ON public."FlexibleFieldDate" USING btree
			("TableId" ASC NULLS LAST)
			TABLESPACE pg_default;

		INSERT INTO public."Versions" ("Path", "Build") VALUES (_path, 0);
		EXCEPTION
			WHEN OTHERS THEN RAISE NOTICE '[ERR] %: %', _path, SQLERRM;
		END;
	END;
$$