DO $$
    DECLARE _path character varying(256) = 'patch-2025_08_14-ProjectTaskUserPerformer';

    BEGIN
        IF EXISTS (SELECT "Id" FROM public."Versions" WHERE "Path"=_path) THEN
            RETURN;
        END IF;

        IF EXISTS (SELECT "Id" FROM public."Versions" WHERE "Build">=15256) THEN
            RETURN;
        END IF;

        BEGIN
            CREATE TABLE public."ProjectTaskUserPerformer" (
	"UserId" bigint NOT NULL,
	"TaskId" bigint NOT NULL,
	"Timestamp" timestamp DEFAULT timezone('utc'::text, now()) NOT NULL,
	CONSTRAINT "ProjectTaskUserPerformer_pkey" PRIMARY KEY ("UserId", "TaskId")
);

CREATE INDEX IF NOT EXISTS  "IDX_ProjectTaskUserPerformer_UserId-TaskId" ON public."ProjectTaskUserPerformer" USING btree ("UserId", "TaskId");


insert into public."ProjectTaskUserPerformer"("UserId","TaskId") select pt."PerformerId", pt."Id" from public."ProjectTasks" pt where pt."PerformerId" is not null;


INSERT INTO public."Versions" ("Path", "Build") VALUES (_path, 0);

            EXCEPTION
				WHEN OTHERS THEN RAISE NOTICE '[ERR] %: %', _path, SQLERRM;
        END;
    END;
$$