DO $$ 
	DECLARE _path character varying(256) = 'patch-2025_09_10-ProjectFlexibleTable';

    BEGIN
		IF EXISTS (SELECT "Id" FROM public."Versions" WHERE "Path"=_path) THEN
			RETURN;
		END IF;
        
         IF EXISTS (SELECT "Id" FROM public."Versions" WHERE "Build">=15305) THEN
		RETURN;
          END IF;
 
        BEGIN
            CREATE TABLE IF NOT EXISTS public."ProjectFlexibleTableLinks" (
                "Id" bigserial NOT NULL,
                "ProjectId" bigint NOT NULL, 
                "TableId" bigint NOT NULL, 
                "AccessType" integer NOT NULL,
                "Timestamp" timestamp without time zone NOT NULL DEFAULT timezone('utc'::text, now()),
                CONSTRAINT "ProjectAttributeLinks_pkey" PRIMARY KEY ("ProjectId","TableId")
            );

        CREATE INDEX IF NOT EXISTS "IDX_ProjectFlexibleTableLinks-Id"
            ON public."ProjectFlexibleTableLinks" USING btree
            ("Id" ASC NULLS LAST)
            TABLESPACE pg_default;

                EXCEPTION
                    WHEN duplicate_table THEN RAISE NOTICE 'Create table <ProjectFlexibleTableLinks>.';
        END;
    END;
$$