﻿DO $$
    DECLARE
        _path character varying(256) := 'patch-2025_12_23UserAddressBooksAddChangedAt';
    BEGIN
        IF EXISTS (SELECT 1 FROM public."Versions" WHERE "Path" = _path) THEN
            RETURN;
        END IF;

        IF EXISTS (SELECT 1 FROM public."Versions" WHERE "Build" >= 15813) THEN
            RETURN;
        END IF;

        BEGIN
 
            ALTER TABLE public."UserAddressBooks" ADD  "ChangedAt" timestamp without time zone DEFAULT timezone('utc', now());

	    update public."UserAddressBooks" set "ChangedAt"="Timestamp";

            INSERT INTO public."Versions" ("Path", "Build") VALUES (_path, 0);

        EXCEPTION
            WHEN OTHERS THEN
                RAISE NOTICE '[ERR] %: %', _path, SQLERRM;
        END;

    END;
$$;