CREATE TABLE public."AccessTokens" (
    "Id" BIGSERIAL PRIMARY KEY,
    "UserId" integer NOT NULL,
    "ApplicationId" integer NOT NULL,
    "DeviceId" bigint,
    "Status" smallint NOT NULL,
    "Token" character varying(4000) NOT NULL,
    "RefreshToken" character varying(4000) NOT NULL,
    "ExpiredAt" timestamp with time zone NOT NULL,
	"Ip"  character varying(1024) NULL,
    "SystemName"  character varying(64) NULL,
	"Timestamp" timestamp without time zone DEFAULT timezone('utc', now())  NOT NULL
); 
 
CREATE INDEX "IDX_AccessTokens_DeviceId-Status"
    ON public."AccessTokens" USING btree
    ("DeviceId" ASC NULLS LAST, "Status" ASC NULLS LAST)
    TABLESPACE pg_default; 

CREATE INDEX "IDX_AccessTokens_Token"
    ON public."AccessTokens" USING btree
    ("Token" COLLATE pg_catalog."default" ASC NULLS LAST)
    TABLESPACE pg_default;


CREATE INDEX "IDX_AccessTokens_UserId-Status"
    ON public."AccessTokens" USING btree
    ("UserId" ASC NULLS LAST, "Status" ASC NULLS LAST)
    TABLESPACE pg_default;  