CREATE TABLE public."Devices" (
    "Id" serial PRIMARY KEY,
    "UserId" integer NOT NULL,
    "Status" smallint NOT NULL,
    "Type" integer NOT NULL,
    "PasswordHash" character varying(1024),
    "DeviceUid" character varying(64) NOT NULL,
    "DevicePushToken" character varying,
    "Description" character varying,
    "ClientVersion" character varying(64) NOT NULL,
    "DeviceModel" character varying(64) NOT NULL,
    "OsVersion" character varying(32) NOT NULL,
    "CreatedAt" timestamp without time zone DEFAULT timezone('utc', now())  NOT NULL
);

CREATE INDEX "IDX_Devices_DeviceUid-UserId"
    ON public."Devices" USING btree
    ("DeviceUid" ASC NULLS LAST, "UserId" ASC NULLS LAST)
    TABLESPACE pg_default; 

CREATE INDEX "IDX_Devices_DeviceUid-Id-DevicePushToken"
    ON public."Devices" USING btree
    ("DeviceUid" ASC NULLS LAST, "Id" ASC NULLS LAST, "DevicePushToken" ASC NULLS LAST)
    TABLESPACE pg_default; 
