CREATE TABLE public."Documents" (
    "Id" bigserial NOT NULL,
    "FileId" bigint NOT NULL,
    "Name" character varying(500) NOT NULL,
    "Hash" character varying(64) NOT NULL,
    "DirectoryId" bigint NOT NULL,
    "Timestamp" timestamp without time zone DEFAULT timezone('utc', now())  NOT NULL,
    "Date" timestamp without time zone NOT NULL,
    "Description" character varying(500),
    "Status" integer DEFAULT 0 NOT NULL,
    "Type" integer DEFAULT 0 NOT NULL,
    "OriginalFileId" bigint,
    "PreviewFileId" bigint,
    "IsDeleted" boolean DEFAULT false,
    "OfflineFileId" bigint,
    "OwnerId" bigint,
    "Size" bigint DEFAULT 0,
    "HasRights" boolean DEFAULT false,
    "HasShare" boolean DEFAULT false,
    PRIMARY KEY ("DirectoryId", "Hash")
);

CREATE INDEX "IDX_Documents_DirectoryId-Timestamp-Id"
    ON public."Documents" USING btree
    ("DirectoryId" ASC NULLS LAST, "Timestamp" ASC NULLS LAST, "Id" ASC NULLS LAST)
    TABLESPACE pg_default;  


CREATE INDEX "IDX_Documents_All2"
    ON public."Documents" USING btree
    ("DirectoryId" ASC NULLS LAST,"Date" ASC NULLS LAST, "Timestamp" ASC NULLS LAST, "Id" ASC NULLS LAST, "OwnerId" ASC NULLS LAST, "Type" ASC NULLS LAST, "Status" ASC NULLS LAST)
    TABLESPACE pg_default;  


CREATE INDEX "IDX_Documents_OwnerId-HasRights-HasShare"
    ON public."Documents" USING btree
    ("OwnerId" ASC NULLS LAST, "HasRights" ASC NULLS LAST, "HasShare" ASC NULLS LAST)
    TABLESPACE pg_default;
