CREATE TABLE IF NOT EXISTS public."Licenses"
(
    "Id" bigserial NOT NULL,
    "InstallationGuid" character varying(1500) NOT NULL,
    "MachineHostname" character varying(4000) NOT NULL,
    "MachineId" character varying(4000) NOT NULL,
    "MachineIp" character varying(4000) NOT NULL,
    "OperatingSystem" character varying(4000) NOT NULL,
    "ProductType" character varying(4000) NOT NULL,
    "SubscriptionId" character varying(4000) NOT NULL,
    "ProductVersion" character varying(4000) NOT NULL,
    "FileName" character varying(4000) NOT NULL,
    "GroupId" character varying(4000),
    "Timestamp" timestamp without time zone NOT NULL DEFAULT timezone('utc'::text, now()),
    "OwnerId" bigint NOT NULL,
    "CustomerId" int not null,
    "Data" text NULL, 
    "Connections" int null, 
    "StartDate" timestamp without time zone,
    "Status" int,
    "EndDate" timestamp without time zone,
    "Key" character varying(1500) NULL,
    "Code" character varying(1500) NULL,
    CONSTRAINT "Licenses_pkey" PRIMARY KEY ("Id")
);
 
 

CREATE INDEX IF NOT EXISTS "IDX_Licenses-CustomerId-OwnerId"
    ON public."Licenses" USING btree
    ("CustomerId" ASC NULLS LAST, "OwnerId" ASC NULLS LAST)
    TABLESPACE pg_default;

CREATE INDEX IF NOT EXISTS "IDX_Licenses-Key-EndDate-MachineId"
    ON public."Licenses" USING btree
    ("Key" ASC NULLS LAST, "EndDate" ASC NULLS LAST, "MachineId" ASC NULLS LAST)
    TABLESPACE pg_default;


CREATE UNIQUE INDEX IF NOT EXISTS "IDX_Licenses-ProductType-MachineId-New"
    ON public."Licenses" USING btree
    ("ProductType" ASC NULLS LAST, "MachineId" ASC NULLS LAST, "CustomerId" ASC NULLS LAST)
    TABLESPACE pg_default;