CREATE TABLE IF NOT EXISTS public."ProjectStatuses"
(
    "Id" bigserial NOT NULL,
    "Name" character varying(200) NOT NULL,
    "Color" character varying(12) NOT NULL,
    "Type" integer NOT NULL,
    "Icon" character varying(128) NULL,
    "IconId" BIGINT NULL, 
    "ImageId" BIGINT NULL,
    "EntityId" BIGINT NULL, 
    "PatternId" BIGINT NULL,
    "Order" BIGINT NULL,   
    "EntityType" BIGINT NOT NULL, 
    "IsDeleted" boolean DEFAULT false NOT NULL,
    "Timestamp" timestamp without time zone NOT NULL DEFAULT timezone('utc'::text, now()),
    CONSTRAINT "ProjectStatuses_pkey" PRIMARY KEY ("Id")
);
CREATE UNIQUE INDEX IF NOT EXISTS "IDX_ProjectStatuses-EnitiyId-EnitiyType-Name"
    ON public."ProjectStatuses" USING btree
    ("EntityId" ASC NULLS LAST, "EntityType" ASC NULLS LAST, "Name" ASC NULLS LAST)
    TABLESPACE pg_default where "IsDeleted" = false;
