DO $$ 
    BEGIN
 IF EXISTS (SELECT "Id" FROM public."Versions" WHERE "Build">=1765) THEN
		RETURN;
          END IF;
        BEGIN
         CREATE TABLE public."EventAttending" (
    "Id" bigserial PRIMARY KEY,
    "StartDate" timestamp NULL, 
    "EndDate" timestamp NULL,
    "EventId" bigint NOT NULL,
    "ContactId" bigint NULL, 
    "Type" integer NOT NULL,
    "Timestamp" timestamp without time zone DEFAULT timezone('utc', now())  NOT NULL,
    "Description" character varying(1024)

);

CREATE INDEX "IDX_EventAttending_EventId"
    ON public."EventAttending" USING btree
    ("EventId" ASC NULLS LAST)
    TABLESPACE pg_default; 
        EXCEPTION
            WHEN duplicate_table THEN RAISE NOTICE 'Create table <EventAttending>.';
        END;
    END;
$$






