
DO $$ 
    BEGIN
         IF EXISTS (SELECT "Id" FROM public."Versions" WHERE "Build">=1765) THEN
		RETURN;
          END IF;
 
        BEGIN
   CREATE TABLE public."UserReactions" (
    "Id" bigserial NOT NULL,
    "EntityId" bigint NOT NULL,
    "EntityType" int NOT NULL,
    "Type" integer NOT NULL,
    "UserId" bigint NOT NULL,
    "Hash" character varying(64) NOT NULL,
    "Timestamp" timestamp without time zone DEFAULT timezone('utc', now())  NOT NULL,
    PRIMARY KEY ("EntityId", "UserId", "EntityType", "Type")
);

CREATE INDEX "IDX_UserReactions_Hash"
    ON public."UserReactions" USING btree
    ("Hash" ASC NULLS LAST)
    TABLESPACE pg_default;  

        EXCEPTION
            WHEN duplicate_table THEN RAISE NOTICE 'Create table <UserReactions>.';
        END;
    END;
$$



