DO $$ 
    BEGIN
          IF EXISTS (SELECT "Id" FROM public."Versions" WHERE "Build">=2772) THEN
		RETURN;
          END IF;
        BEGIN

       

CREATE TABLE IF NOT EXISTS public."ProjectAttachments"
(
    "Id" bigserial NOT NULL ,
    "Name" character varying(500) ,
    "Hash" character varying(64)  NOT NULL,
    "FileId" bigint NOT NULL,
    "EntityId" bigint NOT NULL,
    "ProjectId" bigint NOT NULL,
    "OwnerId" bigint NOT NULL,
    "EntityType" integer NOT NULL,
    "Timestamp" timestamp without time zone NOT NULL DEFAULT timezone('utc'::text, now()),
    CONSTRAINT "ProjectAttachments_pkey" PRIMARY KEY ("FileId", "EntityId", "EntityType")
);
 

CREATE INDEX IF NOT EXISTS "IDX_ProjectAttachments-EntityId"
    ON public."ProjectAttachments" USING btree
    ("EntityId" ASC NULLS LAST, "EntityType" ASC NULLS LAST)
    TABLESPACE pg_default; 

CREATE INDEX IF NOT EXISTS "IDX_ProjectAttachments-FileId"
    ON public."ProjectAttachments" USING btree
    ("FileId" ASC NULLS LAST)
    TABLESPACE pg_default; 

CREATE INDEX IF NOT EXISTS "IDX_ProjectAttachments-Hash"
    ON public."ProjectAttachments" USING btree
    ("Hash" COLLATE pg_catalog."default" ASC NULLS LAST)
    TABLESPACE pg_default; 

CREATE INDEX IF NOT EXISTS "IDX_ProjectAttachments-Id"
    ON public."ProjectAttachments" USING btree
    ("Id" ASC NULLS LAST)
    TABLESPACE pg_default; 

CREATE INDEX IF NOT EXISTS "IDX_ProjectAttachments-ProjectId"
    ON public."ProjectAttachments" USING btree
    ("ProjectId" ASC NULLS LAST)
    TABLESPACE pg_default;

        EXCEPTION
            WHEN OTHERS THEN RAISE NOTICE 'Create table ProjectAttachments error.';
        END;
    END;
$$
