DO $$ 
    BEGIN
          IF EXISTS (SELECT "Id" FROM public."Versions" WHERE "Build">=2772) THEN
		RETURN;
          END IF;
        BEGIN

       	 
	

CREATE TABLE IF NOT EXISTS public."ProjectTaskActivities"
(
    "Id" bigserial NOT NULL,
    "Description" text,
    "AuthorId" bigint NOT NULL,
    "TaskId" bigint NOT NULL,
    "ProjectId" bigint NOT NULL,
    "ParentId" bigint,
    "Type" integer NOT NULL,
    "Json" text,
    "HasAttachments" boolean DEFAULT false,
    "Timestamp" timestamp without time zone NOT NULL DEFAULT timezone('utc'::text, now()),
    CONSTRAINT "ProjectTaskActivities_pkey" PRIMARY KEY ("Id")
);
 

 

CREATE INDEX IF NOT EXISTS "IDX_ProjectTaskActivities-AuthorId-ParentId-Type"
    ON public."ProjectTaskActivities" USING btree
    ("AuthorId" ASC NULLS LAST, "ParentId" ASC NULLS LAST, "Type" ASC NULLS LAST, "HasAttachments" ASC NULLS LAST)
    TABLESPACE pg_default;
 

CREATE INDEX IF NOT EXISTS "IDX_ProjectTaskActivities-ProjectId"
    ON public."ProjectTaskActivities" USING btree
    ("ProjectId" ASC NULLS LAST)
    TABLESPACE pg_default;
 

CREATE INDEX IF NOT EXISTS "IDX_ProjectTaskActivities-TaskId-Timestamp"
    ON public."ProjectTaskActivities" USING btree
    ("TaskId" ASC NULLS LAST, "Timestamp" ASC NULLS LAST)
    TABLESPACE pg_default;

        EXCEPTION
            WHEN OTHERS THEN RAISE NOTICE 'Create table ProjectTaskActivities error.';
        END;
    END;
$$
