DO $$ 
    BEGIN
          IF EXISTS (SELECT "Id" FROM public."Versions" WHERE "Build">=2772) THEN
		RETURN;
          END IF;
        BEGIN

       	 
 

CREATE TABLE IF NOT EXISTS public."Projects"
(
    "Id" bigserial NOT NULL,
    "Name" character varying(1500) NOT NULL,
    "Key" character varying(100)  NOT NULL,
    "Color" character varying(10) ,
    "Type" integer NOT NULL DEFAULT 0,
    "OwnerId" bigint NOT NULL DEFAULT 0,
    "ParentId" bigint,
    "ImageId" bigint,
    "TemplateId" integer,
    "CustomerId" integer NOT NULL,
    "Status" integer NOT NULL DEFAULT 0,
    "ExternalId" character varying(128) ,
    "Timestamp" timestamp without time zone NOT NULL DEFAULT timezone('utc'::text, now()),
    "MaxId" bigint NOT NULL DEFAULT 0,
    "Description" character varying(4000)  ,
    CONSTRAINT "Projects_pkey" PRIMARY KEY ("Key")
);
 

CREATE INDEX IF NOT EXISTS "IDX_Projects-ExternalId"
    ON public."Projects" USING btree
    ("ExternalId" COLLATE pg_catalog."default" ASC NULLS LAST)
    TABLESPACE pg_default;
 

CREATE INDEX IF NOT EXISTS "IDX_Projects-Id-OwnerId"
    ON public."Projects" USING btree
    ("Id" ASC NULLS LAST, "OwnerId" ASC NULLS LAST)
    TABLESPACE pg_default;

        EXCEPTION
            WHEN OTHERS THEN RAISE NOTICE 'Create table Projects error.';
        END;
    END;
$$

 
