DO $$ 
	DECLARE _path character varying(256) = 'patch-2024-05-04-ProductNotification-Create-Table';

	BEGIN
		IF EXISTS (SELECT "Id" FROM public."Versions" WHERE "Path"=_path) THEN
			RETURN;
		END IF;

		IF EXISTS (SELECT "Id" FROM public."Versions" WHERE "Build">=3780) THEN
			RETURN;
		END IF;



		BEGIN
			CREATE TABLE IF NOT EXISTS public."ProductNotification"
			(    
				"Id" bigserial NOT NULL,
				"Key" character varying(255) NOT NULL,
				"Json" character varying NOT NULL,
				"IsEnabled" bool NOT NULL,
				"ChangeAt" timestamp without time zone DEFAULT timezone('utc', now())  NOT NULL,
				CONSTRAINT "UK_ProductNotification" UNIQUE ("Key"));

			INSERT INTO public."Versions" ("Path", "Build") VALUES (_path, 0);
  		EXCEPTION
				WHEN OTHERS THEN RAISE NOTICE 'Create table ProductNotification error.';
		END;
	END;
$$
