CREATE TABLE IF NOT EXISTS public."EventEmailInvite" (
  "MessageId" bigint NOT NULL,
  "OwnerId" bigint NOT NULL, 
  "AttachmentId" bigint NOT NULL,
  "Uid" varchar(256) NOT NULL,
  "EventDetailId" bigint NULL,
  "Sequence" int2 NOT NULL,
  "Method" int2 NOT NULL,
  "State" int2,
  "InsertDate" timestamp without time zone DEFAULT timezone('utc', now()) NOT NULL,
  "CalDavBody" VARCHAR NULL,
  CONSTRAINT "UIDX_EventEmailInvite" UNIQUE ("MessageId")
);

CREATE INDEX  IF NOT EXISTS "IDX_EventEmailInvite_EventDetailId"
  ON public."EventEmailInvite" USING btree
  ("EventDetailId" ASC NULLS LAST)
  TABLESPACE pg_default;

CREATE INDEX IF NOT EXISTS "IDX_EventEmailInvite_Uid"
  ON public."EventEmailInvite" USING btree
  ("Uid" ASC NULLS LAST)
  TABLESPACE pg_default;