DO $$ 
	DECLARE _path character varying(256) = 'patch-2024-08-23-TimeZones_Init_Change';

	BEGIN
		IF EXISTS (SELECT "Id" FROM public."Versions" WHERE "Path"=_path) THEN
			RETURN;
		END IF;

		IF EXISTS (SELECT "Id" FROM public."Versions" WHERE "Build">=14244) THEN
			RETURN;
		END IF;

		BEGIN
			INSERT INTO public."TimeZones" (
			"Name", "UtcOffset", "Abbr", "OffsetMinutes", 
			"HasSummerOffset", "ZoneDescription", 
			"Version"
			) 
			VALUES 
			(
				'Pacific/Niue', '-11:00', 'U',-660, 
				FALSE, '(UTC-11:00) Coordinated Universal Time-11', 
				1
			), 
			(
				'Pacific/Pago_Pago', '-11:00', 'U', 
				-660, FALSE, '(UTC-11:00) Coordinated Universal Time-11', 
				1
			), 
			(
				'Pacific/Honolulu', '-10:00', 'HST', 
				-600, FALSE, '(UTC-10:00) Hawaii', 
				1
			), 
			(
				'Pacific/Rarotonga', '-10:00', 'HST', 
				-600, FALSE, '(UTC-10:00) Hawaii', 
				1
			), 
			(
				'Pacific/Tahiti', '-10:00', 'HST', 
				-600, FALSE, '(UTC-10:00) Hawaii', 
				1
			), 
			(
				'America/Anchorage', '-8:00', 'AKDT', 
				-480, TRUE, '(UTC-09:00) Alaska', 
				1
			), 
			(
				'America/Juneau', '-8:00', 'AKDT', 
				-480, TRUE, '(UTC-09:00) Alaska', 
				1
			), 
			(
				'America/Nome', '-8:00', 'AKDT',-480, 
				TRUE, '(UTC-09:00) Alaska', 1
			), 
			(
				'America/Sitka', '-8:00', 'AKDT', 
				-480, TRUE, '(UTC-09:00) Alaska', 
				1
			), 
			(
				'America/Yakutat', '-8:00', 'AKDT', 
				-480, TRUE, '(UTC-09:00) Alaska', 
				1
			), 
			(
				'America/Los_Angeles', '-8:00', 'PST', 
				-480, FALSE, '(UTC-08:00) Pacific Standard Time (US & Canada)', 
				1
			), 
			(
				'America/Tijuana', '-8:00', 'PST', 
				-480, FALSE, '(UTC-08:00) Pacific Standard Time (US & Canada)', 
				1
			), 
			(
				'America/Vancouver', '-8:00', 'PST', 
				-480, FALSE, '(UTC-08:00) Pacific Standard Time (US & Canada)', 
				1
			), 
			(
				'America/Dawson', '-7:00', 'UMST', 
				-420, FALSE, '(UTC-07:00) Arizona', 
				1
			), 
			(
				'America/Dawson_Creek', '-7:00', 
				'UMST',-420, FALSE, '(UTC-07:00) Arizona', 
				1
			), 
			(
				'America/Hermosillo', '-7:00', 'UMST', 
				-420, FALSE, '(UTC-07:00) Arizona', 
				1
			), 
			(
				'America/Phoenix', '-7:00', 'UMST', 
				-420, FALSE, '(UTC-07:00) Arizona', 
				1
			), 
			(
				'America/Whitehorse', '-7:00', 'UMST', 
				-420, FALSE, '(UTC-07:00) Arizona', 
				1
			), 
			(
				'America/Chihuahua', '-6:00', 'MDT', 
				-360, TRUE, '(UTC-07:00) Chihuahua, La Paz, Mazatlan', 
				1
			), 
			(
				'America/Mazatlan', '-6:00', 'MDT', 
				-360, TRUE, '(UTC-07:00) Chihuahua, La Paz, Mazatlan', 
				1
			), 
			(
				'America/Boise', '-6:00', 'MDT',-360, 
				TRUE, '(UTC-07:00) Mountain Time (US & Canada)', 
				1
			), 
			(
				'America/Cambridge_Bay', '-6:00', 
				'MDT',-360, TRUE, '(UTC-07:00) Mountain Time (US & Canada)', 
				1
			), 
			(
				'America/Denver', '-6:00', 'MDT', 
				-360, TRUE, '(UTC-07:00) Mountain Time (US & Canada)', 
				1
			), 
			(
				'America/Edmonton', '-6:00', 'MDT', 
				-360, TRUE, '(UTC-07:00) Mountain Time (US & Canada)', 
				1
			), 
			(
				'America/Inuvik', '-6:00', 'MDT', 
				-360, TRUE, '(UTC-07:00) Mountain Time (US & Canada)', 
				1
			), 
			(
				'America/Ojinaga', '-6:00', 'MDT', 
				-360, TRUE, '(UTC-07:00) Mountain Time (US & Canada)', 
				1
			), 
			(
				'America/Yellowknife', '-6:00', 'MDT', 
				-360, TRUE, '(UTC-07:00) Mountain Time (US & Canada)', 
				1
			), 
			(
				'America/Belize', '-6:00', 'CAST', 
				-360, FALSE, '(UTC-06:00) Central America', 
				1
			), 
			(
				'America/Costa_Rica', '-6:00', 'CAST', 
				-360, FALSE, '(UTC-06:00) Central America', 
				1
			), 
			(
				'America/El_Salvador', '-6:00', 'CAST', 
				-360, FALSE, '(UTC-06:00) Central America', 
				1
			), 
			(
				'America/Guatemala', '-6:00', 'CAST', 
				-360, FALSE, '(UTC-06:00) Central America', 
				1
			), 
			(
				'America/Managua', '-6:00', 'CAST', 
				-360, FALSE, '(UTC-06:00) Central America', 
				1
			), 
			(
				'America/Tegucigalpa', '-6:00', 'CAST', 
				-360, FALSE, '(UTC-06:00) Central America', 
				1
			), 
			(
				'Pacific/Galapagos', '-6:00', 'CAST', 
				-360, FALSE, '(UTC-06:00) Central America', 
				1
			), 
			(
				'America/Chicago', '-5:00', 'CDT', 
				-300, TRUE, '(UTC-06:00) Central Time (US & Canada)', 
				1
			), 
			(
				'America/Indiana/Knox', '-5:00', 
				'CDT',-300, TRUE, '(UTC-06:00) Central Time (US & Canada)', 
				1
			), 
			(
				'America/Indiana/Tell_City', '-5:00', 
				'CDT',-300, TRUE, '(UTC-06:00) Central Time (US & Canada)', 
				1
			), 
			(
				'America/Matamoros', '-5:00', 'CDT', 
				-300, TRUE, '(UTC-06:00) Central Time (US & Canada)', 
				1
			), 
			(
				'America/Menominee', '-5:00', 'CDT', 
				-300, TRUE, '(UTC-06:00) Central Time (US & Canada)', 
				1
			), 
			(
				'America/North_Dakota/Beulah', '-5:00', 
				'CDT',-300, TRUE, '(UTC-06:00) Central Time (US & Canada)', 
				1
			), 
			(
				'America/North_Dakota/Center', '-5:00', 
				'CDT',-300, TRUE, '(UTC-06:00) Central Time (US & Canada)', 
				1
			), 
			(
				'America/North_Dakota/New_Salem', 
				'-5:00', 'CDT',-300, TRUE, '(UTC-06:00) Central Time (US & Canada)', 
				1
			), 
			(
				'America/Rainy_River', '-5:00', 'CDT', 
				-300, TRUE, '(UTC-06:00) Central Time (US & Canada)', 
				1
			), 
			(
				'America/Rankin_Inlet', '-5:00', 
				'CDT',-300, TRUE, '(UTC-06:00) Central Time (US & Canada)', 
				1
			), 
			(
				'America/Resolute', '-5:00', 'CDT', 
				-300, TRUE, '(UTC-06:00) Central Time (US & Canada)', 
				1
			), 
			(
				'America/Winnipeg', '-5:00', 'CDT', 
				-300, TRUE, '(UTC-06:00) Central Time (US & Canada)', 
				1
			), 
			(
				'America/Bahia_Banderas', '-5:00', 
				'CDT',-300, TRUE, '(UTC-06:00) Guadalajara, Mexico City, Monterrey', 
				1
			), 
			(
				'America/Cancun', '-5:00', 'CDT', 
				-300, TRUE, '(UTC-06:00) Guadalajara, Mexico City, Monterrey', 
				1
			), 
			(
				'America/Merida', '-5:00', 'CDT', 
				-300, TRUE, '(UTC-06:00) Guadalajara, Mexico City, Monterrey', 
				1
			), 
			(
				'America/Mexico_City', '-5:00', 'CDT', 
				-300, TRUE, '(UTC-06:00) Guadalajara, Mexico City, Monterrey', 
				1
			), 
			(
				'America/Monterrey', '-5:00', 'CDT', 
				-300, TRUE, '(UTC-06:00) Guadalajara, Mexico City, Monterrey', 
				1
			), 
			(
				'America/Regina', '-6:00', 'CCST', 
				-360, FALSE, '(UTC-06:00) Saskatchewan', 
				1
			), 
			(
				'America/Swift_Current', '-6:00', 
				'CCST',-360, FALSE, '(UTC-06:00) Saskatchewan', 
				1
			), 
			(
				'America/Bogota', '-5:00', 'SPST', 
				-300, FALSE, '(UTC-05:00) Bogota, Lima, Quito', 
				1
			), 
			(
				'America/Eirunepe', '-5:00', 'SPST', 
				-300, FALSE, '(UTC-05:00) Bogota, Lima, Quito', 
				1
			), 
			(
				'America/Guayaquil', '-5:00', 'SPST', 
				-300, FALSE, '(UTC-05:00) Bogota, Lima, Quito', 
				1
			), 
			(
				'America/Jamaica', '-5:00', 'SPST', 
				-300, FALSE, '(UTC-05:00) Bogota, Lima, Quito', 
				1
			), 
			(
				'America/Lima', '-5:00', 'SPST',-300, 
				FALSE, '(UTC-05:00) Bogota, Lima, Quito', 
				1
			), 
			(
				'America/Panama', '-5:00', 'SPST', 
				-300, FALSE, '(UTC-05:00) Bogota, Lima, Quito', 
				1
			), 
			(
				'America/Rio_Branco', '-5:00', 'SPST', 
				-300, FALSE, '(UTC-05:00) Bogota, Lima, Quito', 
				1
			), 
			(
				'America/Detroit', '-4:00', 'EDT', 
				-240, TRUE, '(UTC-04:00) Eastern Daylight Time (US & Canada)', 
				1
			), 
			(
				'America/Havana', '-4:00', 'EDT', 
				-240, TRUE, '(UTC-04:00) Eastern Daylight Time (US & Canada)', 
				1
			), 
			(
				'America/Indiana/Petersburg', '-4:00', 
				'EDT',-240, TRUE, '(UTC-04:00) Eastern Daylight Time (US & Canada)', 
				1
			), 
			(
				'America/Indiana/Vincennes', '-4:00', 
				'EDT',-240, TRUE, '(UTC-04:00) Eastern Daylight Time (US & Canada)', 
				1
			), 
			(
				'America/Indiana/Winamac', '-4:00', 
				'EDT',-240, TRUE, '(UTC-04:00) Eastern Daylight Time (US & Canada)', 
				1
			), 
			(
				'America/Iqaluit', '-4:00', 'EDT', 
				-240, TRUE, '(UTC-04:00) Eastern Daylight Time (US & Canada)', 
				1
			), 
			(
				'America/Kentucky/Monticello', '-4:00', 
				'EDT',-240, TRUE, '(UTC-04:00) Eastern Daylight Time (US & Canada)', 
				1
			), 
			(
				'America/New_York', '-4:00', 'EDT', 
				-240, TRUE, '(UTC-04:00) Eastern Daylight Time (US & Canada)', 
				1
			), 
			(
				'America/Nipigon', '-4:00', 'EDT', 
				-240, TRUE, '(UTC-04:00) Eastern Daylight Time (US & Canada)', 
				1
			), 
			(
				'America/Pangnirtung', '-4:00', 'EDT', 
				-240, TRUE, '(UTC-04:00) Eastern Daylight Time (US & Canada)', 
				1
			), 
			(
				'America/Port-au-Prince', '-4:00', 
				'EDT',-240, TRUE, '(UTC-04:00) Eastern Daylight Time (US & Canada)', 
				1
			), 
			(
				'America/Thunder_Bay', '-4:00', 'EDT', 
				-240, TRUE, '(UTC-04:00) Eastern Daylight Time (US & Canada)', 
				1
			), 
			(
				'America/Toronto', '-4:00', 'EDT', 
				-240, TRUE, '(UTC-04:00) Eastern Daylight Time (US & Canada)', 
				1
			), 
			(
				'America/Indiana/Marengo', '-5:00', 
				'UEDT',-300, FALSE, '(UTC-05:00) Indiana (East)', 
				1
			), 
			(
				'America/Indiana/Vevay', '-5:00', 
				'UEDT',-300, FALSE, '(UTC-05:00) Indiana (East)', 
				1
			), 
			(
				'America/Caracas', '-4:30', 'VST', 
				-270, FALSE, '(UTC-04:30) Caracas', 
				1
			), 
			(
				'America/Asuncion', '-4:00', 'PYT', 
				-240, FALSE, '(UTC-04:00) Asuncion', 
				1
			), 
			(
				'America/Glace_Bay', '-3:00', 'ADT', 
				-180, TRUE, '(UTC-04:00) Atlantic Time (Canada)', 
				1
			), 
			(
				'America/Goose_Bay', '-3:00', 'ADT', 
				-180, TRUE, '(UTC-04:00) Atlantic Time (Canada)', 
				1
			), 
			(
				'America/Halifax', '-3:00', 'ADT', 
				-180, TRUE, '(UTC-04:00) Atlantic Time (Canada)', 
				1
			), 
			(
				'America/Moncton', '-3:00', 'ADT', 
				-180, TRUE, '(UTC-04:00) Atlantic Time (Canada)', 
				1
			), 
			(
				'America/Thule', '-3:00', 'ADT',-180, 
				TRUE, '(UTC-04:00) Atlantic Time (Canada)', 
				1
			), 
			(
				'Atlantic/Bermuda', '-3:00', 'ADT', 
				-180, TRUE, '(UTC-04:00) Atlantic Time (Canada)', 
				1
			), 
			(
				'America/Campo_Grande', '-4:00', 
				'CBST',-240, FALSE, '(UTC-04:00) Cuiaba', 
				1
			), 
			(
				'America/Cuiaba', '-4:00', 'CBST', 
				-240, FALSE, '(UTC-04:00) Cuiaba', 
				1
			), 
			(
				'America/Barbados', '-4:00', 'SWST', 
				-240, FALSE, '(UTC-04:00) Georgetown, La Paz, Manaus, San Juan', 
				1
			), 
			(
				'America/Boa_Vista', '-4:00', 'SWST', 
				-240, FALSE, '(UTC-04:00) Georgetown, La Paz, Manaus, San Juan', 
				1
			), 
			(
				'America/Grand_Turk', '-4:00', 'SWST', 
				-240, FALSE, '(UTC-04:00) Georgetown, La Paz, Manaus, San Juan', 
				1
			), 
			(
				'America/Guyana', '-4:00', 'SWST', 
				-240, FALSE, '(UTC-04:00) Georgetown, La Paz, Manaus, San Juan', 
				1
			), 
			(
				'America/La_Paz', '-4:00', 'SWST', 
				-240, FALSE, '(UTC-04:00) Georgetown, La Paz, Manaus, San Juan', 
				1
			), 
			(
				'America/Manaus', '-4:00', 'SWST', 
				-240, FALSE, '(UTC-04:00) Georgetown, La Paz, Manaus, San Juan', 
				1
			), 
			(
				'America/Martinique', '-4:00', 'SWST', 
				-240, FALSE, '(UTC-04:00) Georgetown, La Paz, Manaus, San Juan', 
				1
			), 
			(
				'America/Porto_Velho', '-4:00', 'SWST', 
				-240, FALSE, '(UTC-04:00) Georgetown, La Paz, Manaus, San Juan', 
				1
			), 
			(
				'America/Puerto_Rico', '-4:00', 'SWST', 
				-240, FALSE, '(UTC-04:00) Georgetown, La Paz, Manaus, San Juan', 
				1
			), 
			(
				'America/Santo_Domingo', '-4:00', 
				'SWST',-240, FALSE, '(UTC-04:00) Georgetown, La Paz, Manaus, San Juan', 
				1
			), 
			(
				'America/Santiago', '-4:00', 'PSST', 
				-240, FALSE, '(UTC-04:00) Santiago', 
				1
			), 
			(
				'Antarctica/Palmer', '-4:00', 'PSST', 
				-240, FALSE, '(UTC-04:00) Santiago', 
				1
			), 
			(
				'America/St_Johns', '-2:30', 'NDT', 
				-150, TRUE, '(UTC-03:30) Newfoundland', 
				1
			), 
			(
				'America/Sao_Paulo', '-3:00', 'ESAST', 
				-180, FALSE, '(UTC-03:00) Brasilia', 
				1
			), 
			(
				'America/Argentina/Buenos_Aires', 
				'-3:00', 'AST',-180, FALSE, '(UTC-03:00) Buenos Aires', 
				1
			), 
			(
				'America/Argentina/Catamarca', '-3:00', 
				'AST',-180, FALSE, '(UTC-03:00) Buenos Aires', 
				1
			), 
			(
				'America/Argentina/Cordoba', '-3:00', 
				'AST',-180, FALSE, '(UTC-03:00) Buenos Aires', 
				1
			), 
			(
				'America/Argentina/Jujuy', '-3:00', 
				'AST',-180, FALSE, '(UTC-03:00) Buenos Aires', 
				1
			), 
			(
				'America/Argentina/La_Rioja', '-3:00', 
				'AST',-180, FALSE, '(UTC-03:00) Buenos Aires', 
				1
			), 
			(
				'America/Argentina/Mendoza', '-3:00', 
				'AST',-180, FALSE, '(UTC-03:00) Buenos Aires', 
				1
			), 
			(
				'America/Argentina/Rio_Gallegos', 
				'-3:00', 'AST',-180, FALSE, '(UTC-03:00) Buenos Aires', 
				1
			), 
			(
				'America/Argentina/Salta', '-3:00', 
				'AST',-180, FALSE, '(UTC-03:00) Buenos Aires', 
				1
			), 
			(
				'America/Argentina/San_Juan', '-3:00', 
				'AST',-180, FALSE, '(UTC-03:00) Buenos Aires', 
				1
			), 
			(
				'America/Argentina/San_Luis', '-3:00', 
				'AST',-180, FALSE, '(UTC-03:00) Buenos Aires', 
				1
			), 
			(
				'America/Argentina/Tucuman', '-3:00', 
				'AST',-180, FALSE, '(UTC-03:00) Buenos Aires', 
				1
			), 
			(
				'America/Argentina/Ushuaia', '-3:00', 
				'AST',-180, FALSE, '(UTC-03:00) Buenos Aires', 
				1
			), 
			(
				'America/Araguaina', '-3:00', 'SEST', 
				-180, FALSE, '(UTC-03:00) Cayenne, Fortaleza', 
				1
			), 
			(
				'America/Belem', '-3:00', 'SEST', 
				-180, FALSE, '(UTC-03:00) Cayenne, Fortaleza', 
				1
			), 
			(
				'America/Cayenne', '-3:00', 'SEST', 
				-180, FALSE, '(UTC-03:00) Cayenne, Fortaleza', 
				1
			), 
			(
				'America/Fortaleza', '-3:00', 'SEST', 
				-180, FALSE, '(UTC-03:00) Cayenne, Fortaleza', 
				1
			), 
			(
				'America/Maceio', '-3:00', 'SEST', 
				-180, FALSE, '(UTC-03:00) Cayenne, Fortaleza', 
				1
			), 
			(
				'America/Paramaribo', '-3:00', 'SEST', 
				-180, FALSE, '(UTC-03:00) Cayenne, Fortaleza', 
				1
			), 
			(
				'America/Recife', '-3:00', 'SEST', 
				-180, FALSE, '(UTC-03:00) Cayenne, Fortaleza', 
				1
			), 
			(
				'America/Santarem', '-3:00', 'SEST', 
				-180, FALSE, '(UTC-03:00) Cayenne, Fortaleza', 
				1
			), 
			(
				'Antarctica/Rothera', '-3:00', 'SEST', 
				-180, FALSE, '(UTC-03:00) Cayenne, Fortaleza', 
				1
			), 
			(
				'Atlantic/Stanley', '-3:00', 'SEST', 
				-180, FALSE, '(UTC-03:00) Cayenne, Fortaleza', 
				1
			), 
			(
				'America/Montevideo', '-3:00', 'MST', 
				-180, FALSE, '(UTC-03:00) Montevideo', 
				1
			), 
			(
				'America/Bahia', '-3:00', 'BST',-180, 
				FALSE, '(UTC-03:00) Salvador', 1
			), 
			(
				'America/Noronha', '-2:00', 'U',-120, 
				FALSE, '(UTC-02:00) Coordinated Universal Time-02', 
				1
			), 
			(
				'Atlantic/South_Georgia', '-2:00', 
				'U',-120, FALSE, '(UTC-02:00) Coordinated Universal Time-02', 
				1
			), 
			(
				'America/Scoresbysund', '0:00', 'ADT', 
				0, TRUE, '(UTC-01:00) Azores', 1
			), 
			(
				'Atlantic/Azores', '0:00', 'ADT', 
				0, TRUE, '(UTC-01:00) Azores', 1
			), 
			(
				'Atlantic/Cape_Verde', '-1:00', 'CVST', 
				-60, FALSE, '(UTC-01:00) Cape Verde Is.', 
				1
			), 
			(
				'Africa/Casablanca', '1:00', 'MDT', 
				60, TRUE, '(UTC) Casablanca', 1
			), 
			(
				'Africa/El_Aaiun', '1:00', 'MDT', 
				60, TRUE, '(UTC) Casablanca', 1
			), 
			(
				'America/Danmarkshavn', '0:00', 'UTC', 
				0, FALSE, '(UTC) Coordinated Universal Time', 
				1
			), 
			(
				'Europe/London', '1:00', 'BST', 60, 
				TRUE, '(UTC+01:00) Edinburgh, London', 
				1
			), 
			(
				'Atlantic/Canary', '1:00', 'GDT', 
				60, TRUE, '(UTC) Dublin, Lisbon', 
				1
			), 
			(
				'Atlantic/Madeira', '1:00', 'GDT', 
				60, TRUE, '(UTC) Dublin, Lisbon', 
				1
			), 
			(
				'Europe/Dublin', '1:00', 'GDT', 60, 
				TRUE, '(UTC) Dublin, Lisbon', 1
			), 
			(
				'Europe/Lisbon', '1:00', 'GDT', 60, 
				TRUE, '(UTC) Dublin, Lisbon', 1
			), 
			(
				'Africa/Abidjan', '0:00', 'GST', 0, 
				FALSE, '(UTC) Monrovia, Reykjavik', 
				1
			), 
			(
				'Africa/Bissau', '0:00', 'GST', 0, 
				FALSE, '(UTC) Monrovia, Reykjavik', 
				1
			), 
			(
				'Africa/Monrovia', '0:00', 'GST', 
				0, FALSE, '(UTC) Monrovia, Reykjavik', 
				1
			), 
			(
				'Africa/Sao_Tome', '0:00', 'GST', 
				0, FALSE, '(UTC) Monrovia, Reykjavik', 
				1
			), 
			(
				'Atlantic/Reykjavik', '0:00', 'GST', 
				0, FALSE, '(UTC) Monrovia, Reykjavik', 
				1
			), 
			(
				'Europe/Amsterdam', '2:00', 'WEDT', 
				120, TRUE, '(UTC+01:00) Amsterdam, Berlin, Bern, Rome, Stockholm, Vienna', 
				1
			), 
			(
				'Europe/Andorra', '2:00', 'WEDT', 
				120, TRUE, '(UTC+01:00) Amsterdam, Berlin, Bern, Rome, Stockholm, Vienna', 
				1
			), 
			(
				'Europe/Berlin', '2:00', 'WEDT', 120, 
				TRUE, '(UTC+01:00) Amsterdam, Berlin, Bern, Rome, Stockholm, Vienna', 
				1
			), 
			(
				'Europe/Gibraltar', '2:00', 'WEDT', 
				120, TRUE, '(UTC+01:00) Amsterdam, Berlin, Bern, Rome, Stockholm, Vienna', 
				1
			), 
			(
				'Europe/Luxembourg', '2:00', 'WEDT', 
				120, TRUE, '(UTC+01:00) Amsterdam, Berlin, Bern, Rome, Stockholm, Vienna', 
				1
			), 
			(
				'Europe/Malta', '2:00', 'WEDT', 120, 
				TRUE, '(UTC+01:00) Amsterdam, Berlin, Bern, Rome, Stockholm, Vienna', 
				1
			), 
			(
				'Europe/Monaco', '2:00', 'WEDT', 120, 
				TRUE, '(UTC+01:00) Amsterdam, Berlin, Bern, Rome, Stockholm, Vienna', 
				1
			), 
			(
				'Europe/Oslo', '2:00', 'WEDT', 120, 
				TRUE, '(UTC+01:00) Amsterdam, Berlin, Bern, Rome, Stockholm, Vienna', 
				1
			), 
			(
				'Europe/Rome', '2:00', 'WEDT', 120, 
				TRUE, '(UTC+01:00) Amsterdam, Berlin, Bern, Rome, Stockholm, Vienna', 
				1
			), 
			(
				'Europe/Stockholm', '2:00', 'WEDT', 
				120, TRUE, '(UTC+01:00) Amsterdam, Berlin, Bern, Rome, Stockholm, Vienna', 
				1
			), 
			(
				'Europe/Vienna', '2:00', 'WEDT', 120, 
				TRUE, '(UTC+01:00) Amsterdam, Berlin, Bern, Rome, Stockholm, Vienna', 
				1
			), 
			(
				'Europe/Zurich', '2:00', 'WEDT', 120, 
				TRUE, '(UTC+01:00) Amsterdam, Berlin, Bern, Rome, Stockholm, Vienna', 
				1
			), 
			(
				'Europe/Belgrade', '2:00', 'CEDT', 
				120, TRUE, '(UTC+01:00) Belgrade, Bratislava, Budapest, Ljubljana, Prague', 
				1
			), 
			(
				'Europe/Budapest', '2:00', 'CEDT', 
				120, TRUE, '(UTC+01:00) Belgrade, Bratislava, Budapest, Ljubljana, Prague', 
				1
			), 
			(
				'Europe/Prague', '2:00', 'CEDT', 120, 
				TRUE, '(UTC+01:00) Belgrade, Bratislava, Budapest, Ljubljana, Prague', 
				1
			), 
			(
				'Europe/Tirane', '2:00', 'CEDT', 120, 
				TRUE, '(UTC+01:00) Belgrade, Bratislava, Budapest, Ljubljana, Prague', 
				1
			), 
			(
				'Africa/Ceuta', '2:00', 'RDT', 120, 
				TRUE, '(UTC+01:00) Brussels, Copenhagen, Madrid, Paris', 
				1
			), 
			(
				'Europe/Brussels', '2:00', 'RDT', 
				120, TRUE, '(UTC+01:00) Brussels, Copenhagen, Madrid, Paris', 
				1
			), 
			(
				'Europe/Copenhagen', '2:00', 'RDT', 
				120, TRUE, '(UTC+01:00) Brussels, Copenhagen, Madrid, Paris', 
				1
			), 
			(
				'Europe/Madrid', '2:00', 'RDT', 120, 
				TRUE, '(UTC+01:00) Brussels, Copenhagen, Madrid, Paris', 
				1
			), 
			(
				'Europe/Paris', '2:00', 'RDT', 120, 
				TRUE, '(UTC+01:00) Brussels, Copenhagen, Madrid, Paris', 
				1
			), 
			(
				'Europe/Warsaw', '2:00', 'CEDT', 120, 
				TRUE, '(UTC+01:00) Sarajevo, Skopje, Warsaw, Zagreb', 
				1
			), 
			(
				'Africa/Algiers', '1:00', 'WCAST', 
				60, FALSE, '(UTC+01:00) West Central Africa', 
				1
			), 
			(
				'Africa/Lagos', '1:00', 'WCAST', 60, 
				FALSE, '(UTC+01:00) West Central Africa', 
				1
			), 
			(
				'Africa/Ndjamena', '1:00', 'WCAST', 
				60, FALSE, '(UTC+01:00) West Central Africa', 
				1
			), 
			(
				'Africa/Tunis', '1:00', 'WCAST', 60, 
				FALSE, '(UTC+01:00) West Central Africa', 
				1
			), 
			(
				'Africa/Windhoek', '1:00', 'NST', 
				60, FALSE, '(UTC+01:00) Windhoek', 
				1
			), 
			(
				'Asia/Nicosia', '3:00', 'EEDT', 180, 
				TRUE, '(UTC+02:00) E. Europe', 1
			), 
			(
				'Europe/Athens', '3:00', 'EEDT', 180, 
				TRUE, '(UTC+02:00) E. Europe', 1
			), 
			(
				'Europe/Bucharest', '3:00', 'EEDT', 
				180, TRUE, '(UTC+02:00) E. Europe', 
				1
			), 
			(
				'Europe/Chisinau', '3:00', 'EEDT', 
				180, TRUE, '(UTC+02:00) E. Europe', 
				1
			), 
			(
				'Asia/Beirut', '3:00', 'MEDT', 180, 
				TRUE, '(UTC+02:00) Beirut', 1
			), 
			(
				'Africa/Cairo', '2:00', 'EST', 120, 
				FALSE, '(UTC+02:00) Cairo', 1
			), 
			(
				'Asia/Damascus', '3:00', 'SDT', 180, 
				TRUE, '(UTC+02:00) Damascus', 1
			), 
			(
				'Europe/Helsinki', '3:00', 'FDT', 
				180, TRUE, '(UTC+02:00) Helsinki, Kyiv, Riga, Sofia, Tallinn, Vilnius', 
				1
			), 
			(
				'Europe/Riga', '3:00', 'FDT', 180, 
				TRUE, '(UTC+02:00) Helsinki, Kyiv, Riga, Sofia, Tallinn, Vilnius', 
				1
			), 
			(
				'Europe/Sofia', '3:00', 'FDT', 180, 
				TRUE, '(UTC+02:00) Helsinki, Kyiv, Riga, Sofia, Tallinn, Vilnius', 
				1
			), 
			(
				'Europe/Tallinn', '3:00', 'FDT', 180, 
				TRUE, '(UTC+02:00) Helsinki, Kyiv, Riga, Sofia, Tallinn, Vilnius', 
				1
			), 
			(
				'Europe/Vilnius', '3:00', 'FDT', 180, 
				TRUE, '(UTC+02:00) Helsinki, Kyiv, Riga, Sofia, Tallinn, Vilnius', 
				1
			), 
			(
				'Africa/Johannesburg', '2:00', 'SAST', 
				120, FALSE, '(UTC+02:00) Harare, Pretoria', 
				1
			), 
			(
				'Africa/Maputo', '2:00', 'SAST', 120, 
				FALSE, '(UTC+02:00) Harare, Pretoria', 
				1
			), 
			(
				'Europe/Istanbul', '3:00', 'TDT', 
				180, FALSE, '(UTC+03:00) Istanbul', 
				1
			), 
			(
				'Asia/Jerusalem', '3:00', 'JDT', 180, 
				TRUE, '(UTC+02:00) Jerusalem', 1
			), 
			(
				'Africa/Tripoli', '2:00', 'LST', 120, 
				FALSE, '(UTC+02:00) Tripoli', 1
			), 
			(
				'Asia/Amman', '3:00', 'JST', 180, FALSE, 
				'(UTC+03:00) Amman', 1
			), 
			(
				'Asia/Baghdad', '3:00', 'AST', 180, 
				FALSE, '(UTC+03:00) Baghdad', 1
			), 
			(
				'Europe/Kaliningrad', '3:00', 'KST', 
				180, FALSE, '(UTC+02:00) Kaliningrad', 
				1
			), 
			(
				'Asia/Qatar', '3:00', 'AST', 180, FALSE, 
				'(UTC+03:00) Kuwait, Riyadh', 1
			), 
			(
				'Asia/Riyadh', '3:00', 'AST', 180, 
				FALSE, '(UTC+03:00) Kuwait, Riyadh', 
				1
			), 
			(
				'Africa/Juba', '3:00', 'EAST', 180, 
				FALSE, '(UTC+03:00) Nairobi', 1
			), 
			(
				'Africa/Khartoum', '3:00', 'EAST', 
				180, FALSE, '(UTC+03:00) Nairobi', 
				1
			), 
			(
				'Africa/Nairobi', '3:00', 'EAST', 
				180, FALSE, '(UTC+03:00) Nairobi', 
				1
			), 
			(
				'Europe/Kirov', '3:00', 'MSK', 180, 
				FALSE, '(UTC+03:00) Moscow, St. Petersburg, Volgograd, Minsk', 
				1
			), 
			(
				'Europe/Moscow', '3:00', 'MSK', 180, 
				FALSE, '(UTC+03:00) Moscow, St. Petersburg, Volgograd, Minsk', 
				1
			), 
			(
				'Europe/Simferopol', '3:00', 'MSK', 
				180, FALSE, '(UTC+03:00) Moscow, St. Petersburg, Volgograd, Minsk', 
				1
			), 
			(
				'Europe/Volgograd', '3:00', 'MSK', 
				180, FALSE, '(UTC+03:00) Moscow, St. Petersburg, Volgograd, Minsk', 
				1
			), 
			(
				'Europe/Minsk', '3:00', 'MSK', 180, 
				FALSE, '(UTC+03:00) Moscow, St. Petersburg, Volgograd, Minsk', 
				1
			), 
			(
				'Europe/Astrakhan', '4:00', 'SAMT', 
				240, FALSE, '(UTC+04:00) Samara, Ulyanovsk, Saratov', 
				1
			), 
			(
				'Europe/Samara', '4:00', 'SAMT', 240, 
				FALSE, '(UTC+04:00) Samara, Ulyanovsk, Saratov', 
				1
			), 
			(
				'Europe/Ulyanovsk', '4:00', 'SAMT', 
				240, FALSE, '(UTC+04:00) Samara, Ulyanovsk, Saratov', 
				1
			), 
			(
				'Asia/Tehran', '4:30', 'IDT', 270, 
				TRUE, '(UTC+03:30) Tehran', 1
			), 
			(
				'Asia/Dubai', '4:00', 'AST', 240, FALSE, 
				'(UTC+04:00) Abu Dhabi, Muscat', 
				1
			), 
			(
				'Asia/Baku', '5:00', 'ADT', 300, TRUE, 
				'(UTC+04:00) Baku', 1
			), 
			(
				'Indian/Mahe', '4:00', 'MST', 240, 
				FALSE, '(UTC+04:00) Port Louis', 
				1
			), 
			(
				'Indian/Mauritius', '4:00', 'MST', 
				240, FALSE, '(UTC+04:00) Port Louis', 
				1
			), 
			(
				'Indian/Reunion', '4:00', 'MST', 240, 
				FALSE, '(UTC+04:00) Port Louis', 
				1
			), 
			(
				'Asia/Tbilisi', '4:00', 'GET', 240, 
				FALSE, '(UTC+04:00) Tbilisi', 1
			), 
			(
				'Asia/Yerevan', '4:00', 'CST', 240, 
				FALSE, '(UTC+04:00) Yerevan', 1
			), 
			(
				'Asia/Kabul', '4:30', 'AST', 270, FALSE, 
				'(UTC+04:30) Kabul', 1
			), 
			(
				'Antarctica/Mawson', '5:00', 'WAST', 
				300, FALSE, '(UTC+05:00) Ashgabat, Tashkent', 
				1
			), 
			(
				'Asia/Aqtau', '5:00', 'WAST', 300, 
				FALSE, '(UTC+05:00) Ashgabat, Tashkent', 
				1
			), 
			(
				'Asia/Aqtobe', '5:00', 'WAST', 300, 
				FALSE, '(UTC+05:00) Ashgabat, Tashkent', 
				1
			), 
			(
				'Asia/Ashgabat', '5:00', 'WAST', 300, 
				FALSE, '(UTC+05:00) Ashgabat, Tashkent', 
				1
			), 
			(
				'Asia/Dushanbe', '5:00', 'WAST', 300, 
				FALSE, '(UTC+05:00) Ashgabat, Tashkent', 
				1
			), 
			(
				'Asia/Oral', '5:00', 'WAST', 300, FALSE, 
				'(UTC+05:00) Ashgabat, Tashkent', 
				1
			), 
			(
				'Asia/Samarkand', '5:00', 'WAST', 
				300, FALSE, '(UTC+05:00) Ashgabat, Tashkent', 
				1
			), 
			(
				'Asia/Tashkent', '5:00', 'WAST', 300, 
				FALSE, '(UTC+05:00) Ashgabat, Tashkent', 
				1
			), 
			(
				'Indian/Kerguelen', '5:00', 'WAST', 
				300, FALSE, '(UTC+05:00) Ashgabat, Tashkent', 
				1
			), 
			(
				'Indian/Maldives', '5:00', 'WAST', 
				300, FALSE, '(UTC+05:00) Ashgabat, Tashkent', 
				1
			), 
			(
				'Asia/Yekaterinburg', '5:00', 'YEKT', 
				300, FALSE, '(UTC+05:00) Yekaterinburg', 
				1
			), 
			(
				'Asia/Karachi', '5:00', 'PKT', 300, 
				FALSE, '(UTC+05:00) Islamabad, Karachi', 
				1
			), 
			(
				'Asia/Kolkata', '5:30', 'IST', 330, 
				FALSE, '(UTC+05:30) Chennai, Kolkata, Mumbai, New Delhi', 
				1
			), 
			(
				'Asia/Colombo', '5:30', 'SLST', 330, 
				FALSE, '(UTC+05:30) Sri Jayawardenepura', 
				1
			), 
			(
				'Asia/Kathmandu', '5:45', 'NST', 345, 
				FALSE, '(UTC+05:45) Kathmandu', 
				1
			), 
			(
				'Antarctica/Vostok', '6:00', 'CAST', 
				360, FALSE, '(UTC+06:00) Nur-Sultan (Astana)', 
				1
			), 
			(
				'Asia/Almaty', '6:00', 'CAST', 360, 
				FALSE, '(UTC+06:00) Nur-Sultan (Astana)', 
				1
			), 
			(
				'Asia/Bishkek', '6:00', 'CAST', 360, 
				FALSE, '(UTC+06:00) Nur-Sultan (Astana)', 
				1
			), 
			(
				'Asia/Qyzylorda', '6:00', 'CAST', 
				360, FALSE, '(UTC+06:00) Nur-Sultan (Astana)', 
				1
			), 
			(
				'Asia/Urumqi', '6:00', 'CAST', 360, 
				FALSE, '(UTC+06:00) Nur-Sultan (Astana)', 
				1
			), 
			(
				'Indian/Chagos', '6:00', 'CAST', 360, 
				FALSE, '(UTC+06:00) Nur-Sultan (Astana)', 
				1
			), 
			(
				'Asia/Dhaka', '6:00', 'BST', 360, FALSE, 
				'(UTC+06:00) Dhaka', 1
			), 
			(
				'Asia/Thimphu', '6:00', 'BST', 360, 
				FALSE, '(UTC+06:00) Dhaka', 1
			), 
			(
				'Indian/Cocos', '6:30', 'MST', 390, 
				FALSE, '(UTC+06:30) Yangon (Rangoon)', 
				1
			), 
			(
				'Antarctica/Davis', '7:00', 'SAST', 
				420, FALSE, '(UTC+07:00) Bangkok, Hanoi, Jakarta', 
				1
			), 
			(
				'Asia/Bangkok', '7:00', 'SAST', 420, 
				FALSE, '(UTC+07:00) Bangkok, Hanoi, Jakarta', 
				1
			), 
			(
				'Asia/Hovd', '7:00', 'SAST', 420, FALSE, 
				'(UTC+07:00) Bangkok, Hanoi, Jakarta', 
				1
			), 
			(
				'Asia/Jakarta', '7:00', 'SAST', 420, 
				FALSE, '(UTC+07:00) Bangkok, Hanoi, Jakarta', 
				1
			), 
			(
				'Asia/Pontianak', '7:00', 'SAST', 
				420, FALSE, '(UTC+07:00) Bangkok, Hanoi, Jakarta', 
				1
			), 
			(
				'Indian/Christmas', '7:00', 'SAST', 
				420, FALSE, '(UTC+07:00) Bangkok, Hanoi, Jakarta', 
				1
			), 
			(
				'Asia/Novokuznetsk', '7:00', 'NCAST', 
				420, FALSE, '(UTC+07:00) Novosibirsk', 
				1
			), 
			(
				'Asia/Novosibirsk', '7:00', 'NCAST', 
				420, FALSE, '(UTC+07:00) Novosibirsk', 
				1
			), 
			(
				'Asia/Omsk', '7:00', 'NCAST', 420, 
				FALSE, '(UTC+07:00) Novosibirsk', 
				1
			), 
			(
				'Asia/Hong_Kong', '8:00', 'CST', 480, 
				FALSE, '(UTC+08:00) Beijing, Chongqing, Hong Kong, Urumqi', 
				1
			), 
			(
				'Asia/Macau', '8:00', 'CST', 480, FALSE, 
				'(UTC+08:00) Beijing, Chongqing, Hong Kong, Urumqi', 
				1
			), 
			(
				'Asia/Shanghai', '8:00', 'CST', 480, 
				FALSE, '(UTC+08:00) Beijing, Chongqing, Hong Kong, Urumqi', 
				1
			), 
			(
				'Asia/Krasnoyarsk', '8:00', 'NAST', 
				480, FALSE, '(UTC+08:00) Krasnoyarsk', 
				1
			), 
			(
				'Asia/Brunei', '8:00', 'MPST', 480, 
				FALSE, '(UTC+08:00) Kuala Lumpur, Singapore', 
				1
			), 
			(
				'Asia/Kuala_Lumpur', '8:00', 'MPST', 
				480, FALSE, '(UTC+08:00) Kuala Lumpur, Singapore', 
				1
			), 
			(
				'Asia/Kuching', '8:00', 'MPST', 480, 
				FALSE, '(UTC+08:00) Kuala Lumpur, Singapore', 
				1
			), 
			(
				'Asia/Makassar', '8:00', 'MPST', 480, 
				FALSE, '(UTC+08:00) Kuala Lumpur, Singapore', 
				1
			), 
			(
				'Asia/Manila', '8:00', 'MPST', 480, 
				FALSE, '(UTC+08:00) Kuala Lumpur, Singapore', 
				1
			), 
			(
				'Asia/Singapore', '8:00', 'MPST', 
				480, FALSE, '(UTC+08:00) Kuala Lumpur, Singapore', 
				1
			), 
			(
				'Antarctica/Casey', '8:00', 'WAST', 
				480, FALSE, '(UTC+08:00) Perth', 
				1
			), 
			(
				'Australia/Perth', '8:00', 'WAST', 
				480, FALSE, '(UTC+08:00) Perth', 
				1
			), 
			(
				'Asia/Taipei', '8:00', 'TST', 480, 
				FALSE, '(UTC+08:00) Taipei', 1
			), 
			(
				'Asia/Choibalsan', '8:00', 'UST', 
				480, FALSE, '(UTC+08:00) Ulaanbaatar', 
				1
			), 
			(
				'Asia/Ulaanbaatar', '8:00', 'UST', 
				480, FALSE, '(UTC+08:00) Ulaanbaatar', 
				1
			), 
			(
				'Asia/Irkutsk', '8:00', 'NAEST', 480, 
				FALSE, '(UTC+08:00) Irkutsk', 1
			), 
			(
				'Asia/Dili', '9:00', 'JST', 540, FALSE, 
				'(UTC+09:00) Osaka, Sapporo, Tokyo', 
				1
			), 
			(
				'Asia/Jayapura', '9:00', 'JST', 540, 
				FALSE, '(UTC+09:00) Osaka, Sapporo, Tokyo', 
				1
			), 
			(
				'Asia/Tokyo', '9:00', 'JST', 540, FALSE, 
				'(UTC+09:00) Osaka, Sapporo, Tokyo', 
				1
			), 
			(
				'Pacific/Palau', '9:00', 'JST', 540, 
				FALSE, '(UTC+09:00) Osaka, Sapporo, Tokyo', 
				1
			), 
			(
				'Asia/Pyongyang', '9:00', 'KST', 540, 
				FALSE, '(UTC+09:00) Seoul', 1
			), 
			(
				'Asia/Seoul', '9:00', 'KST', 540, FALSE, 
				'(UTC+09:00) Seoul', 1
			), 
			(
				'Australia/Adelaide', '9:30', 'CAST', 
				570, FALSE, '(UTC+09:30) Adelaide', 
				1
			), 
			(
				'Australia/Broken_Hill', '9:30', 
				'CAST', 570, FALSE, '(UTC+09:30) Adelaide', 
				1
			), 
			(
				'Australia/Darwin', '9:30', 'ACST', 
				570, FALSE, '(UTC+09:30) Darwin', 
				1
			), 
			(
				'Australia/Brisbane', '10:00', 'EAST', 
				600, FALSE, '(UTC+10:00) Brisbane', 
				1
			), 
			(
				'Australia/Lindeman', '10:00', 'EAST', 
				600, FALSE, '(UTC+10:00) Brisbane', 
				1
			), 
			(
				'Australia/Melbourne', '10:00', 'AEST', 
				600, FALSE, '(UTC+10:00) Canberra, Melbourne, Sydney', 
				1
			), 
			(
				'Australia/Sydney', '10:00', 'AEST', 
				600, FALSE, '(UTC+10:00) Canberra, Melbourne, Sydney', 
				1
			), 
			(
				'Pacific/Guam', '10:00', 'WPST', 600, 
				FALSE, '(UTC+10:00) Guam, Port Moresby', 
				1
			), 
			(
				'Pacific/Port_Moresby', '10:00', 
				'WPST', 600, FALSE, '(UTC+10:00) Guam, Port Moresby', 
				1
			), 
			(
				'Australia/Hobart', '10:00', 'TST', 
				600, FALSE, '(UTC+10:00) Hobart', 
				1
			), 
			(
				'Asia/Chita', '9:00', 'YST', 540, FALSE, 
				'(UTC+09:00) Yakutsk', 1
			), 
			(
				'Asia/Khandyga', '9:00', 'YST', 540, 
				FALSE, '(UTC+09:00) Yakutsk', 1
			), 
			(
				'Asia/Yakutsk', '9:00', 'YST', 540, 
				FALSE, '(UTC+09:00) Yakutsk', 1
			), 
			(
				'Antarctica/Macquarie', '11:00', 
				'CPST', 660, FALSE, '(UTC+11:00) Solomon Is., New Caledonia', 
				1
			), 
			(
				'Pacific/Efate', '11:00', 'CPST', 
				660, FALSE, '(UTC+11:00) Solomon Is., New Caledonia', 
				1
			), 
			(
				'Pacific/Guadalcanal', '11:00', 'CPST', 
				660, FALSE, '(UTC+11:00) Solomon Is., New Caledonia', 
				1
			), 
			(
				'Pacific/Kosrae', '11:00', 'CPST', 
				660, FALSE, '(UTC+11:00) Solomon Is., New Caledonia', 
				1
			), 
			(
				'Pacific/Noumea', '11:00', 'CPST', 
				660, FALSE, '(UTC+11:00) Solomon Is., New Caledonia', 
				1
			), 
			(
				'Asia/Sakhalin', '11:00', 'VST', 660, 
				FALSE, '(UTC+11:00) Vladivostok', 
				1
			), 
			(
				'Asia/Ust-Nera', '11:00', 'VST', 660, 
				FALSE, '(UTC+11:00) Vladivostok', 
				1
			), 
			(
				'Asia/Vladivostok', '11:00', 'VST', 
				660, FALSE, '(UTC+11:00) Vladivostok', 
				1
			), 
			(
				'Pacific/Auckland', '12:00', 'NZST', 
				720, FALSE, '(UTC+12:00) Auckland, Wellington', 
				1
			), 
			(
				'Pacific/Funafuti', '12:00', 'U', 
				720, FALSE, '(UTC+12:00) Coordinated Universal Time+12', 
				1
			), 
			(
				'Pacific/Kwajalein', '12:00', 'U', 
				720, FALSE, '(UTC+12:00) Coordinated Universal Time+12', 
				1
			), 
			(
				'Pacific/Majuro', '12:00', 'U', 720, 
				FALSE, '(UTC+12:00) Coordinated Universal Time+12', 
				1
			), 
			(
				'Pacific/Nauru', '12:00', 'U', 720, 
				FALSE, '(UTC+12:00) Coordinated Universal Time+12', 
				1
			), 
			(
				'Pacific/Tarawa', '12:00', 'U', 720, 
				FALSE, '(UTC+12:00) Coordinated Universal Time+12', 
				1
			), 
			(
				'Pacific/Wake', '12:00', 'U', 720, 
				FALSE, '(UTC+12:00) Coordinated Universal Time+12', 
				1
			), 
			(
				'Pacific/Wallis', '12:00', 'U', 720, 
				FALSE, '(UTC+12:00) Coordinated Universal Time+12', 
				1
			), 
			(
				'Pacific/Fiji', '12:00', 'FST', 720, 
				FALSE, '(UTC+12:00) Fiji', 1
			), 
			(
				'Asia/Anadyr', '12:00', 'MST', 720, 
				FALSE, '(UTC+12:00) Magadan', 1
			), 
			(
				'Asia/Kamchatka', '13:00', 'KDT', 
				780, TRUE, '(UTC+12:00) Petropavlovsk-Kamchatsky - Old', 
				1
			), 
			(
				'Asia/Magadan', '12:00', 'MST', 720, 
				FALSE, '(UTC+12:00) Magadan', 1
			), 
			(
				'Asia/Srednekolymsk', '12:00', 'MST', 
				720, FALSE, '(UTC+12:00) Magadan', 
				1
			), 
			(
				'Pacific/Fakaofo', '13:00', 'TST', 
				780, FALSE, '(UTC+13:00) Nuku`alofa', 
				1
			), 
			(
				'Pacific/Tongatapu', '13:00', 'TST', 
				780, FALSE, '(UTC+13:00) Nuku`alofa', 
				1
			), 
			(
				'Pacific/Apia', '13:00', 'SST', 780, 
				FALSE, '(UTC+13:00) Samoa', 1
			), 
			(
				'Pacific/Norfolk', '11:00', '', 660, 
				TRUE, '', 1
			), 
			(
				'Pacific/Bougainville', '11:00', 
				'', 660, FALSE, '', 1
			), 
			(
				'Europe/Kiyv', '2:00', '', 120, TRUE, 
				'', 1
			), 
			(
				'Pacific/Kanton', '13:00', '', 780, 
				FALSE, '', 1
			), 
			(
				'Pacific/Pohnpei', '11:00', '', 660, 
				FALSE, '', 1
			), 
			(
				'Pacific/Pitcairn', '-8:00', '',-480, 
				FALSE, '', 1
			), 
			(
				'Pacific/Easter', '-6:00', '',-360, 
				TRUE, '', 1
			), 
			(
				'Australia/Lord_Howe', '10:30', '', 
				630, TRUE, '', 1
			), 
			(
				'America/Adak', '-10:00', '',-600, 
				TRUE, '', 1
			), 
			(
				'Asia/Atyrau', '5:00', '', 300, FALSE, 
				'', 1
			), 
			(
				'America/Kentucky/Louisville', '-5:00', 
				'',-300, TRUE, '', 1
			), 
			(
				'America/Ciudad_Juarez', '-7:00', 
				'',-420, TRUE, '', 1
			), 
			(
				'Pacific/Gambier', '-9:00', '',-540, 
				FALSE, '', 1
			), 
			(
				'Asia/Qostanay', '6:00', '', 360, FALSE, 
				'', 1
			), 
			(
				'Asia/Yangon', '6:30', '', 390, FALSE, 
				'', 1
			), 
			(
				'Etc/UTC', '0:00', '', 0, FALSE, '', 
				1
			), 
			(
				'Europe/Saratov', '4:00', '', 240, 
				FALSE, '', 1
			), 
			(
				'Pacific/Chuuk', '10:00', '', 600, 
				FALSE, '', 1
			), 
			(
				'America/Miquelon', '-3:00', '',-180, 
				TRUE, '', 1
			), 
			(
				'America/Indiana/Indianapolis', 
				'-5:00', '',-300, TRUE, '', 1
			), 
			(
				'America/Punta_Arenas', '-3:00', 
				'',-180, FALSE, '', 1
			), 
			(
				'Asia/Gaza', '2:00', '', 120, TRUE, 
				'', 1
			), 
			(
				'Pacific/Kiritimati', '14:00', '', 
				840, FALSE, '', 1
			), 
			(
				'Asia/Ho_Chi_Minh', '7:00', '', 420, 
				FALSE, '', 1
			), 
			(
				'Asia/Tomsk', '7:00', '', 420, FALSE, 
				'', 1
			), 
			(
				'Asia/Famagusta', '2:00', '', 120, 
				TRUE, '', 1
			), 
			(
				'Pacific/Marquesas', '-9:30', '', 
				-570, FALSE, '', 1
			), 
			(
				'Australia/Eucla', '8:45', '', 525, 
				FALSE, '', 1
			), 
			(
				'Pacific/Chatham', '12:45', '', 765, 
				TRUE, '', 1
			), 
			(
				'America/Fort_Nelson', '-7:00', '', 
				-420, FALSE, '', 1
			), 
			(
				'America/Metlakatla', '-9:00', '', 
				-540, TRUE, '', 1
			), 
			(
				'America/Nuuk', '-2:00', '',-120, 
				TRUE, '', 1
			), 
			(
				'Asia/Barnaul', '7:00', '', 420, FALSE, 
				'', 1
			), 
			(
				'Asia/Hebron', '2:00', '', 120, TRUE, 
				'', 1
			), 
			(
				'Antarctica/Troll', '0:00', '', 0, 
				TRUE, '', 1
			), 
			(
				'Atlantic/Faroe', '0:00', '', 0, TRUE, 
				'', 1
			);

 			INSERT INTO public."Versions" ("Path", "Build") VALUES (_path, 0);
			EXCEPTION
				WHEN OTHERS THEN RAISE NOTICE '[ERR] patch-2024-08-23-TimeZones_Init_Change: %', SQLERRM;
		END;
	END;
$$