
DO $$ 
    BEGIN
         IF EXISTS (SELECT "Id" FROM public."Versions" WHERE "Build">=14592) THEN
		RETURN;
          END IF;
 
        BEGIN
  

CREATE TABLE IF NOT EXISTS public."ProjectAttributeOptions"
(
    "Id" bigserial NOT NULL PRIMARY KEY,
    "ProjectId" bigint NOT NULL, 
    "AttributeId" bigint NOT NULL, 
    "ImageId" bigint NULL,   
    "Order" int NULL,
    "Color" character varying(64)  NULL,  
    "Value" text
);
CREATE INDEX IF NOT EXISTS "IDX_ProjectAttributeOptions-ProjectId-AttributeId"
    ON public."ProjectAttributeOptions" USING btree
    ("ProjectId" ASC NULLS LAST,"AttributeId" ASC NULLS LAST)
    TABLESPACE pg_default; 
  
        EXCEPTION
            WHEN duplicate_table THEN RAISE NOTICE 'Can not Create table <ProjectAttributeOptions>.';
        END;
    END;
$$









