DO $$ 
	DECLARE _path character varying(256) = 'patch-2024-11-19-EmailTimeSentItems_create';

	BEGIN
		IF EXISTS (SELECT "Id" FROM public."Versions" WHERE "Path"=_path) THEN
			RETURN;
		END IF;

		IF EXISTS (SELECT "Id" FROM public."Versions" WHERE "Build">=14592) THEN
			RETURN;
		END IF;

		BEGIN
			CREATE TABLE public."EmailTimeSentItems"
			(
				"MessageId" BIGINT NOT NULL,
				"UserId" BIGINT NOT NULL,
				"SendTime" timestamp NOT NULL,
				"IsCancelled" boolean default false,
				CONSTRAINT "UIDX_EmailTimeSentItems" UNIQUE ("MessageId")
			);

           EXCEPTION
			WHEN OTHERS THEN RAISE NOTICE '[ERR] patch-2024-11-19-EmailTimeSentItems_create: %', SQLERRM;
		END;
	END;
$$