DO $$ 
	DECLARE _path character varying(256) = 'patch-2024-12-13-NotificationUsers_recreate';

	BEGIN
		IF EXISTS (SELECT "Id" FROM public."Versions" WHERE "Path"=_path) THEN
			RETURN;
		END IF;

		IF EXISTS (SELECT "Id" FROM public."Versions" WHERE "Build">=14909) THEN
			RETURN;
		END IF;

		BEGIN
		
			DROP TABLE public."NotificationUsers";
			CREATE TABLE public."NotificationUsers" (
				"Id" bigserial NOT NULL,
				"UserId" bigint NOT NULL,
				"NotificationId" bigint NOT NULL,
				"State" integer DEFAULT 0 NOT NULL,
				"Timestamp" timestamp without time zone DEFAULT timezone('utc', now())  NOT NULL,
				PRIMARY KEY ("UserId", "NotificationId")
			);

			CREATE INDEX "IDX_NotificationUsers_UserId" ON public."NotificationUsers" USING btree ("UserId");
			
			INSERT INTO public."Versions" ("Path", "Build") VALUES (_path, 0);
           EXCEPTION
			WHEN OTHERS THEN RAISE NOTICE '[ERR] patch-2024-12-13-NotificationUsers_recreate: %', SQLERRM;
		END;
	END;
$$