DO $$ 
	DECLARE _path character varying(256) = 'patch-2024-12-26-ProjectDeleteUserId';

	BEGIN
		IF EXISTS (SELECT "Id" FROM public."Versions" WHERE "Path"=_path) THEN
			RETURN;
		END IF;

		IF EXISTS (SELECT "Id" FROM public."Versions" WHERE "Build">=14592) THEN
			RETURN;
		END IF;

		BEGIN
			ALTER TABLE public."ProjectTasks" ADD  "DeleteUserId" bigint NULL;
			ALTER TABLE public."ProjectSprints" ADD  "DeleteUserId" bigint NULL;
			ALTER TABLE public."Projects" ADD  "DeleteUserId" bigint NULL;
			
			INSERT INTO public."Versions" ("Path", "Build") VALUES (_path, 0);
           EXCEPTION
			WHEN OTHERS THEN RAISE NOTICE '[ERR] patch-2024-12-26-ProjectDeleteUserId: %', SQLERRM;
		END;
	END;
$$