DO $$ 
	DECLARE _path character varying(256) = 'patch-2025-02-17-ChangePrimaryMessageSettings.sql';

	BEGIN
		IF EXISTS (SELECT "Id" FROM public."Versions" WHERE "Path"=_path) THEN
			RETURN;
		END IF;

		IF EXISTS (SELECT "Id" FROM public."Versions" WHERE "Build">=14721) THEN
			RETURN;
		END IF;

		BEGIN

			CREATE TABLE public."MessageSettingsNew" (
    "Id" bigserial NOT NULL,
    "Key" character varying(128),
    "Value" character varying NOT NULL,
    "Lang" character varying(12) NOT NULL,
    "Timestamp" timestamp without time zone DEFAULT timezone('utc', now())  NOT NULL,
    CONSTRAINT "PK_MessageSettings" PRIMARY KEY ("Key","Lang")

); 

INSERT INTO public."MessageSettingsNew" ("Key","Value","Lang","Timestamp")
SELECT "Key","Value","Lang","Timestamp" FROM public."MessageSettings";
ALTER TABLE public."MessageSettings" RENAME TO "MessageSettings_Old";
ALTER TABLE public."MessageSettingsNew" RENAME TO "MessageSettings";
	


 			INSERT INTO public."Versions" ("Path", "Build") VALUES (_path, 0);
			EXCEPTION
				WHEN OTHERS THEN RAISE NOTICE '[ERR] patch-2025-02-17-ChangePrimaryMessageSettings: %', SQLERRM;
		END;
	END;
$$