DO $$ 
	DECLARE _path character varying(256) = 'patch-2025_05_13-NameCollate';

	BEGIN
		IF EXISTS (SELECT "Id" FROM public."Versions" WHERE "Path"=_path) THEN
			RETURN;
		END IF;

		IF EXISTS (SELECT "Id" FROM public."Versions" WHERE "Build">=14695) THEN
			RETURN;
		END IF;

		BEGIN
			CREATE COLLATION numeric (provider = icu, locale = 'en@colNumeric=yes');
			ALTER TABLE public."DocumentDirectories" ALTER COLUMN "Name" type TEXT COLLATE numeric;

			ALTER TABLE public."Documents" ALTER COLUMN "Name" type TEXT COLLATE numeric;
			INSERT INTO public."Versions" ("Path", "Build") VALUES (_path, 0);
			EXCEPTION
				WHEN OTHERS THEN RAISE NOTICE '[ERR] patch-2025_04_28-InitOAuthApplications: %', SQLERRM;
		END;
	END;
$$
