DO $$ 
	DECLARE _path character varying(256) = 'patch-2025_05_14-DocumentDirectoriesExpirationDate';

	BEGIN
		IF EXISTS (SELECT "Id" FROM public."Versions" WHERE "Path"=_path) THEN
			RETURN;
		END IF;

		IF EXISTS (SELECT "Id" FROM public."Versions" WHERE "Build">=14956) THEN
			RETURN;
		END IF;

		BEGIN
            		
			ALTER TABLE public."DocumentDirectories"  ADD "ExpirationDate" timestamp NULL;
 

			CREATE INDEX "IDX_DocumentDirectories_ExpirationDate"
    				ON public."DocumentDirectories" USING btree
    				("ExpirationDate" ASC NULLS LAST)
    				TABLESPACE pg_default;  

			INSERT INTO public."Versions" ("Path", "Build") VALUES (_path, 0);
			EXCEPTION
				WHEN OTHERS THEN RAISE NOTICE '[ERR] patch-2025_05_14-DocumentDirectoriesExpirationDate: %', SQLERRM;


		END;
	END;
$$