﻿DO $$ 
	DECLARE _path character varying(256) = 'patch-2025-06-30-ProjectLabelsOrder';

	BEGIN
		IF EXISTS (SELECT "Id" FROM public."Versions" WHERE "Path"=_path) THEN
			RETURN;
		END IF;

		IF EXISTS (SELECT "Id" FROM public."Versions" WHERE "Build">=15160) THEN
			RETURN;
		END IF;

		BEGIN

			CREATE TABLE IF NOT EXISTS public."ProjectTaskLabelLinks"
				( 
						"Id" bigserial NOT NULL,
						"EntityId" bigint NOT NULL, 
						"EntityType" int4 NOT NULL, 
						"LabelId" bigint NOT NULL,
						 CONSTRAINT "ProjectTaskLabelLinks_pkey" PRIMARY KEY ("Id")
				);

				CREATE INDEX IF NOT EXISTS "IDX_ProjectTaskLabelLinks-LabelId-EntityId"
						ON public."ProjectTaskLabelLinks" USING btree
						("LabelId"ASC NULLS LAST,"EntityId"ASC NULLS LAST)
						TABLESPACE pg_default;
    
				CREATE INDEX IF NOT EXISTS "IDX_ProjectTaskLabelLinks-LabelId"
						ON public."ProjectTaskLabelLinks" USING btree
						("LabelId"ASC NULLS LAST)
						TABLESPACE pg_default;
            		
			ALTER TABLE public."ProjectLabels" ADD "Order" int4 DEFAULT 0 NOT NULL;

			INSERT INTO public."Versions" ("Path", "Build") VALUES (_path, 0);

			EXCEPTION
				WHEN OTHERS THEN RAISE NOTICE '[ERR] patch-2025-06-30-ProjectLabelsOrder: %', SQLERRM;
		END;
	END;
$$