CREATE TABLE public."ChatUserRelations" (
    "Id" bigserial NOT NULL,
    "OwnerId" bigint NOT NULL,
    "ContactId" bigint NOT NULL,
    "Name" character varying(255) NOT NULL,
    "Enable" boolean DEFAULT true NOT NULL,
    "State" integer DEFAULT 0 NOT NULL,
    "UserId" bigint,
    "Json" character varying,
    "Timestamp" timestamp without time zone DEFAULT timezone('utc', now()),
    "HoldTo" timestamp without time zone,
    PRIMARY KEY ("OwnerId", "ContactId")
);

CREATE INDEX "ChatUserRelations_IX_FK_ChatUserRelations"
    ON public."ChatUserRelations" USING btree
    ("UserId" ASC NULLS LAST)
    TABLESPACE pg_default;


CREATE INDEX "ChatUserRelations_IX_FK_ChatUserRelationsContactId"
    ON public."ChatUserRelations" USING btree
    ("ContactId" ASC NULLS LAST)
    TABLESPACE pg_default;


CREATE INDEX "ChatUserRelations_IX_FK_ChatUserRelationsOwnerId"
    ON public."ChatUserRelations" USING btree
    ("OwnerId" ASC NULLS LAST)
    TABLESPACE pg_default; 