CREATE TABLE public."RoleAccessRights" (
    "RoleId" integer NOT NULL,
    "EntityId" bigint NOT NULL,
    "EntityType" integer NOT NULL,
    "Timestamp" timestamp without time zone DEFAULT timezone('utc', now())  NOT NULL,
    "Type" integer DEFAULT 0 NOT NULL,
    "OwnerId" bigint,
    PRIMARY KEY ("RoleId", "EntityType", "EntityId")
);

CREATE INDEX "IDX_RoleAccessRights_EntityId-EntityType-OwnerId"
    ON public."RoleAccessRights" USING btree
    ("EntityId" ASC NULLS LAST,"EntityType" ASC NULLS LAST,"OwnerId" ASC NULLS LAST)
    TABLESPACE pg_default; 

CREATE INDEX "IDX_RoleAccessRights_RoleId-EntityId-EntityType"
    ON public."RoleAccessRights" USING btree
    ("RoleId" ASC NULLS LAST,"EntityId" ASC NULLS LAST,"EntityType" ASC NULLS LAST)
    TABLESPACE pg_default; 

