CREATE TABLE public."Roles" (
    "Id" serial PRIMARY KEY,
    "Name" character varying(1024) NOT NULL,
    "CustomerId" integer,
    "Type" integer DEFAULT 0 NOT NULL,
    "Timestamp" timestamp without time zone DEFAULT timezone('utc', now())  NOT NULL,
    "ParentId" bigint,
    "ChangeDate" timestamp null,
    "Email" character varying(1024),
    "ExternalId" character varying(64),
	"OwnerId" bigint NULL
);

CREATE INDEX "IDX_Roles_Type-CustomerId"
    ON public."Roles" USING btree
    ("Type" ASC NULLS LAST,"CustomerId" ASC NULLS LAST)
    TABLESPACE pg_default; 