DO $$ 
    BEGIN
        BEGIN
          CREATE TABLE public."UserQuotas"
(
	"Id" bigserial NOT NULL,
	"Name" character varying(64) NOT NULL,
	"Size" bigint NOT NULL,
	"CustomerId" int,
	"IsDefault" BOOLEAN NOT NULL DEFAULT(false)
);

CREATE INDEX "IDX_UserQuotas-Id-Name-Size"
		ON public."UserQuotas" USING btree
		("Id" ASC NULLS LAST, "Name" ASC NULLS LAST, "Size" ASC NULLS LAST)
		TABLESPACE pg_default; 
	
        EXCEPTION
            WHEN duplicate_table THEN RAISE NOTICE 'Create table <UserQuotas>.';
        END;
    END;
$$


