CREATE TABLE public."DocumentVersions" (
    "DocumentId" bigint NOT NULL,
    "FileId" bigint NOT NULL,
    "Timestamp" timestamp without time zone DEFAULT timezone('utc', now())  NOT NULL,
    PRIMARY KEY ("FileId", "DocumentId")
); 

CREATE INDEX "IDX_DocumentVersions_DocumentId"
    ON public."DocumentVersions" USING btree
    ("DocumentId" ASC NULLS LAST)
    TABLESPACE pg_default;  