CREATE TABLE public."Files" (
    "Id" bigserial PRIMARY KEY,
    "Status" integer DEFAULT 0 NOT NULL,
    "Name" character varying(500) NOT NULL,
    "MimeType" character varying(128) NOT NULL,
    "Json" character varying(2048) DEFAULT '{}'::character varying NOT NULL,
    "Size" bigint NOT NULL,
    "Description" character varying(500),
    "OwnerId" bigint NOT NULL,
    "ExternalId" character varying(64),
    "StorageId" bigint NULL,
    "Timestamp" timestamp without time zone DEFAULT timezone('utc', now())  NOT NULL,
    "AccessModifier" integer DEFAULT 0 NOT NULL,
    "DirectoryId" bigint
);

 
CREATE INDEX "IDX_Files_OwnerId-AccessModifier-Size"
    ON public."Files" USING btree
    ("Id" ASC NULLS LAST,"OwnerId" ASC NULLS LAST,"AccessModifier" ASC NULLS LAST,"Size" ASC NULLS LAST)
    TABLESPACE pg_default; 
