CREATE TABLE public."SharedLinks" (
    "Id" bigserial NOT NULL,
    "Uid" character varying(64) NOT NULL,
    "Hash" character varying(64) NOT NULL,
    "EntityId" bigint NOT NULL,
    "EntityType" integer NOT NULL,
    "LifeTime" integer NOT NULL,
    "UserId" bigint NOT NULL,
    "AccessType" integer NOT NULL,
    "Timestamp" timestamp without time zone DEFAULT timezone('utc', now())  NOT NULL,
    "Password" character varying(500) NULL,
    "ExpirationDate" timestamp NULL,
     CONSTRAINT "PK_SharedLinks" PRIMARY KEY ("Hash")
); 

CREATE INDEX "IDX_SharedLinks_All"
    ON public."SharedLinks" USING btree
    ("Uid" ASC NULLS LAST, "EntityId" ASC NULLS LAST, "EntityType" ASC NULLS LAST, "LifeTime" ASC NULLS LAST, "UserId" ASC NULLS LAST, "AccessType" ASC NULLS LAST)
    TABLESPACE pg_default;  

CREATE INDEX "IDX_SharedLinks_Id"
    ON public."SharedLinks" USING btree
    ("Id" ASC NULLS LAST)
    TABLESPACE pg_default; 