CREATE TABLE public."EventDetails" (
    "Id" bigserial PRIMARY KEY,
    "OwnerId" bigint NOT NULL,
    "ParentId" BIGINT NULL,
    "CalendarId" bigint NOT NULL,
    "CategoryId" bigint NOT NULL,
    "RecurringId" bigint,
    "Type" integer NOT NULL,
    "Name" character varying(1024),
    "ExternalId" character varying(500),
    "Description" character varying(4000),
    "DurationInSeconds" bigint NOT NULL,
    "Place" character varying(1024),
    "Address" character varying(1024),
    "GeoId" bigint,
    "IsExchangeEvent" boolean DEFAULT false NOT NULL,
    "IsPrivate" boolean DEFAULT false NOT NULL,
    "HasMaterials" boolean,
    "HasParticipant" boolean DEFAULT false,
    "Uid" character varying(256),
    "IsAllDay" boolean NULL DEFAULT false,
    "TimeZoneId" int NULL,
    "EndTimeZoneId" int NULL,
    "LastModificationDate" timestamp without time zone DEFAULT timezone('utc', now()) NOT NULL,
    "Timestamp" timestamp without time zone DEFAULT timezone('utc', now()) NOT NULL,
    "Sequence" int DEFAULT 0 NOT NULL,
    "OrganizerId" bigint NULL,
    "SourceType" int2 NULL,
    "IsFree" int4 NULL,
    "RecurrenceDt" timestamp NULL,
    "StartDate" timestamp NOT NULL,
    "OriginalId" bigint null,
    "AccessType" int2 NULL,
    "CreatorId" bigint null,
    "NotificationsPresence" int2 DEFAULT 0 NOT NULL
);

CREATE INDEX "IDX_EventDetails_Uid"
    ON public."EventDetails" USING btree
    ("Uid" ASC NULLS LAST)
    TABLESPACE pg_default; 

CREATE INDEX "IDX_EventDetails_ParentId"
    ON public."EventDetails" USING btree
    ("ParentId" ASC NULLS LAST)
    TABLESPACE pg_default; 

CREATE INDEX "IDX_EventDetails_CalendarId"
    ON public."EventDetails" USING btree
    ("CalendarId" ASC NULLS LAST)
    TABLESPACE pg_default; 

CREATE INDEX "IDX_EventDetails_OwnerId"
    ON public."EventDetails" USING btree
    ("OwnerId" ASC NULLS LAST)
    TABLESPACE pg_default; 

CREATE INDEX "IDX_EventDetails_RecurringId"
    ON public."EventDetails" USING btree
    ("RecurringId" ASC NULLS LAST)
    TABLESPACE pg_default; 