CREATE TABLE IF NOT EXISTS public."FlexibleTableFields"
(
    "Id" bigserial NOT NULL,
    "Name" character varying(1000) NOT NULL,
    "Pattern" character varying(1000) NULL,
    "Format" character varying(1000) NULL,
    "TableId" bigint NOT NULL,
    "Type" integer NOT NULL DEFAULT 0,
    "ViewType" integer NOT NULL DEFAULT 1,
    "Timestamp" timestamp without time zone NOT NULL DEFAULT timezone('utc'::text, now()),
    CONSTRAINT "FlexibleTableFields_pkey" PRIMARY KEY ("Name", "TableId")
);

CREATE INDEX IF NOT EXISTS "IDX_FlexibleTableFields-TableId"
    ON public."FlexibleTableFields" USING btree
    ("TableId" ASC NULLS LAST)
    TABLESPACE pg_default;
